/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.transport.tcp.client;

import io.netty.buffer.ByteBuf;
import io.reactivesocket.DuplexConnection;
import io.reactivesocket.Frame;
import io.reactivesocket.transport.TransportClient;
import io.reactivesocket.transport.tcp.ReactiveSocketFrameCodec;
import io.reactivesocket.transport.tcp.ReactiveSocketFrameLogger;
import io.reactivesocket.transport.tcp.ReactiveSocketLengthCodec;
import io.reactivesocket.transport.tcp.TcpDuplexConnection;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.protocol.tcp.client.TcpClient;
import java.net.SocketAddress;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.event.Level;
import rx.Observable;
import rx.RxReactiveStreams;

public class TcpTransportClient
implements TransportClient {
    private final TcpClient<Frame, Frame> rxNettyClient;

    public TcpTransportClient(TcpClient<Frame, Frame> client) {
        this.rxNettyClient = client;
    }

    public Publisher<DuplexConnection> connect() {
        return RxReactiveStreams.toPublisher((Observable)this.rxNettyClient.createConnectionRequest().map(connection -> new TcpDuplexConnection((Connection<Frame, Frame>)connection)));
    }

    public TcpTransportClient configureClient(Function<TcpClient<Frame, Frame>, TcpClient<Frame, Frame>> configurator) {
        return new TcpTransportClient(configurator.apply(this.rxNettyClient));
    }

    public TcpTransportClient logReactiveSocketFrames(String name, Level logLevel) {
        return this.configureClient(c -> c.addChannelHandlerLast("reactive-socket-frame-codec", () -> new ReactiveSocketFrameLogger(name, logLevel)));
    }

    public static TcpTransportClient create(SocketAddress serverAddress) {
        return new TcpTransportClient(TcpTransportClient._configureClient((TcpClient<ByteBuf, ByteBuf>)TcpClient.newClient((SocketAddress)serverAddress)));
    }

    public static TcpTransportClient create(TcpClient<ByteBuf, ByteBuf> client) {
        return new TcpTransportClient(TcpTransportClient._configureClient(client));
    }

    private static TcpClient<Frame, Frame> _configureClient(TcpClient<ByteBuf, ByteBuf> client) {
        return client.addChannelHandlerLast("length-codec", ReactiveSocketLengthCodec::new).addChannelHandlerLast("frame-codec", ReactiveSocketFrameCodec::new);
    }
}

