/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.transport.tcp;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.reactivesocket.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ReactiveSocketFrameLogger
extends ChannelDuplexHandler {
    private final Logger logger;
    private final Level logLevel;

    public ReactiveSocketFrameLogger(String name, Level logLevel) {
        this.logLevel = logLevel;
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.logFrameIfEnabled(ctx, msg, " Writing frame: ");
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.logFrameIfEnabled(ctx, msg, " Read frame: ");
        super.channelRead(ctx, msg);
    }

    private void logFrameIfEnabled(ChannelHandlerContext ctx, Object msg, String logMsgPrefix) {
        if (msg instanceof Frame) {
            Frame f = (Frame)msg;
            switch (this.logLevel) {
                case ERROR: {
                    if (!this.logger.isErrorEnabled()) break;
                    this.logger.error(ctx.channel() + logMsgPrefix + f);
                    break;
                }
                case WARN: {
                    if (!this.logger.isWarnEnabled()) break;
                    this.logger.warn(ctx.channel() + logMsgPrefix + f);
                    break;
                }
                case INFO: {
                    if (!this.logger.isInfoEnabled()) break;
                    this.logger.info(ctx.channel() + logMsgPrefix + f);
                    break;
                }
                case DEBUG: {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug(ctx.channel() + logMsgPrefix + f);
                    break;
                }
                case TRACE: {
                    if (!this.logger.isTraceEnabled()) break;
                    this.logger.trace(ctx.channel() + logMsgPrefix + f);
                }
            }
        }
    }
}

