/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.transport.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.reactivesocket.Frame;
import io.reactivesocket.transport.tcp.MutableDirectByteBuf;
import java.nio.ByteBuffer;
import org.agrona.MutableDirectBuffer;

public class ReactiveSocketFrameCodec
extends ChannelDuplexHandler {
    private final MutableDirectByteBuf buffer = new MutableDirectByteBuf(Unpooled.buffer((int)0));
    private final Frame frame = Frame.allocate((MutableDirectBuffer)this.buffer);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            try {
                this.buffer.wrap((ByteBuf)msg);
                this.frame.wrap((MutableDirectBuffer)this.buffer, 0);
                ctx.fireChannelRead((Object)this.frame);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Frame) {
            ByteBuffer src = ((Frame)msg).getByteBuffer();
            ByteBuf toWrite = ctx.alloc().buffer(src.remaining()).writeBytes(src);
            ctx.write((Object)toWrite, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }
}

