/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.transport.tcp;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class MutableDirectByteBuf
implements MutableDirectBuffer {
    private ByteBuf byteBuf;

    public MutableDirectByteBuf(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public void wrap(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public ByteBuf byteBuf() {
        return this.byteBuf;
    }

    public static ByteBuffer slice(ByteBuffer byteBuffer, int position, int limit) {
        int savedPosition = byteBuffer.position();
        int savedLimit = byteBuffer.limit();
        byteBuffer.limit(limit).position(position);
        ByteBuffer result = byteBuffer.slice();
        byteBuffer.limit(savedLimit).position(savedPosition);
        return result;
    }

    public boolean isExpandable() {
        return false;
    }

    public void setMemory(int index, int length, byte value) {
        for (int i = index; i < index + length; ++i) {
            this.byteBuf.setByte(i, (int)value);
        }
    }

    public void putLong(int index, long value, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        this.byteBuf.setLong(index, value);
    }

    public void putLong(int index, long value) {
        this.byteBuf.setLong(index, value);
    }

    public void putInt(int index, int value, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        this.byteBuf.setInt(index, value);
    }

    public void putInt(int index, int value) {
        this.byteBuf.setInt(index, value);
    }

    public void putDouble(int index, double value, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        this.byteBuf.setDouble(index, value);
    }

    public void putDouble(int index, double value) {
        this.byteBuf.setDouble(index, value);
    }

    public void putFloat(int index, float value, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        this.byteBuf.setFloat(index, value);
    }

    public void putFloat(int index, float value) {
        this.byteBuf.setFloat(index, value);
    }

    public void putShort(int index, short value, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        this.byteBuf.setShort(index, (int)value);
    }

    public void putShort(int index, short value) {
        this.byteBuf.setShort(index, (int)value);
    }

    public void putByte(int index, byte value) {
        this.byteBuf.setByte(index, (int)value);
    }

    public void putBytes(int index, byte[] src) {
        this.byteBuf.setBytes(index, src);
    }

    public void putBytes(int index, byte[] src, int offset, int length) {
        this.byteBuf.setBytes(index, src, offset, length);
    }

    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        ByteBuffer sliceBuffer = MutableDirectByteBuf.slice(srcBuffer, 0, length);
        this.byteBuf.setBytes(index, sliceBuffer);
    }

    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        ByteBuffer sliceBuffer = MutableDirectByteBuf.slice(srcBuffer, srcIndex, srcIndex + length);
        this.byteBuf.setBytes(index, sliceBuffer);
    }

    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        throw new UnsupportedOperationException("putBytes(DirectBuffer) not supported");
    }

    public int putStringUtf8(int offset, String value, ByteOrder byteOrder) {
        throw new UnsupportedOperationException("putStringUtf8 not supported");
    }

    public int putStringUtf8(int offset, String value, ByteOrder byteOrder, int maxEncodedSize) {
        throw new UnsupportedOperationException("putStringUtf8 not supported");
    }

    public int putStringWithoutLengthUtf8(int offset, String value) {
        throw new UnsupportedOperationException("putStringUtf8 not supported");
    }

    public void wrap(byte[] buffer) {
        throw new UnsupportedOperationException("wrap(byte[]) not supported");
    }

    public void wrap(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException("wrap(byte[]) not supported");
    }

    public void wrap(ByteBuffer buffer) {
        throw new UnsupportedOperationException("wrap(ByteBuffer) not supported");
    }

    public void wrap(ByteBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException("wrap(ByteBuffer) not supported");
    }

    public void wrap(DirectBuffer buffer) {
        throw new UnsupportedOperationException("wrap(DirectBuffer) not supported");
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException("wrap(DirectBuffer) not supported");
    }

    public void wrap(long address, int length) {
        throw new UnsupportedOperationException("wrap(address) not supported");
    }

    public long addressOffset() {
        return this.byteBuf.memoryAddress();
    }

    public byte[] byteArray() {
        return this.byteBuf.array();
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuf.nioBuffer();
    }

    public int capacity() {
        return this.byteBuf.capacity();
    }

    public void checkLimit(int limit) {
        throw new UnsupportedOperationException("checkLimit not supported");
    }

    public long getLong(int index, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        return this.byteBuf.getLong(index);
    }

    public long getLong(int index) {
        return this.byteBuf.getLong(index);
    }

    public int getInt(int index, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        return this.byteBuf.getInt(index);
    }

    public int getInt(int index) {
        return this.byteBuf.getInt(index);
    }

    public double getDouble(int index, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        return this.byteBuf.getDouble(index);
    }

    public double getDouble(int index) {
        return this.byteBuf.getDouble(index);
    }

    public float getFloat(int index, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        return this.byteBuf.getFloat(index);
    }

    public float getFloat(int index) {
        return this.byteBuf.getFloat(index);
    }

    public short getShort(int index, ByteOrder byteOrder) {
        this.ensureByteOrder(byteOrder);
        return this.byteBuf.getShort(index);
    }

    public short getShort(int index) {
        return this.byteBuf.getShort(index);
    }

    public byte getByte(int index) {
        return this.byteBuf.getByte(index);
    }

    public void getBytes(int index, byte[] dst) {
        this.byteBuf.getBytes(index, dst);
    }

    public void getBytes(int index, byte[] dst, int offset, int length) {
        this.byteBuf.getBytes(index, dst, offset, length);
    }

    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        throw new UnsupportedOperationException("getBytes(MutableDirectBuffer) not supported");
    }

    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        throw new UnsupportedOperationException("getBytes(ByteBuffer) not supported");
    }

    public void getBytes(int index, ByteBuffer dstBuffer, int dstOffset, int length) {
        throw new UnsupportedOperationException("getBytes(ByteBuffer) not supported");
    }

    public String getStringUtf8(int offset, ByteOrder byteOrder) {
        int length = this.getInt(offset, byteOrder);
        return this.byteBuf.toString(offset + 4, length, StandardCharsets.UTF_8);
    }

    public String getStringUtf8(int offset, int length) {
        return this.byteBuf.toString(offset, length, StandardCharsets.UTF_8);
    }

    public String getStringWithoutLengthUtf8(int offset, int length) {
        return this.byteBuf.toString(offset, length, StandardCharsets.UTF_8);
    }

    public void boundsCheck(int index, int length) {
        throw new UnsupportedOperationException("boundsCheck not supported");
    }

    public int wrapAdjustment() {
        throw new UnsupportedOperationException("wrapAdjustment not supported");
    }

    private void ensureByteOrder(ByteOrder byteOrder) {
        if (this.byteBuf.order() != byteOrder) {
            this.byteBuf.order(byteOrder);
        }
    }

    public void putChar(int index, char value, ByteOrder byteOrder) {
        throw new UnsupportedOperationException("getBytes(MutableDirectBuffer) not supported");
    }

    public void putChar(int index, char value) {
        throw new UnsupportedOperationException("getBytes(MutableDirectBuffer) not supported");
    }

    public int putStringUtf8(int offset, String value) {
        throw new UnsupportedOperationException("getBytes(MutableDirectBuffer) not supported");
    }

    public int putStringUtf8(int index, String value, int maxEncodedSize) {
        throw new UnsupportedOperationException("getBytes(MutableDirectBuffer) not supported");
    }

    public char getChar(int index, ByteOrder byteOrder) {
        throw new UnsupportedOperationException("getBytes(MutableDirectBuffer) not supported");
    }

    public char getChar(int index) {
        throw new UnsupportedOperationException("getBytes(MutableDirectBuffer) not supported");
    }

    public String getStringUtf8(int index) {
        return null;
    }

    public int compareTo(DirectBuffer o) {
        throw new UnsupportedOperationException("compareTo not supported");
    }
}

