/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.hibernate.orm.deployment.IgnorableNonIndexedClasses;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.generate.SpringDataRepositoryCreator;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.springframework.data.domain.Auditable;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.QueryByExampleExecutor;

public class SpringDataJPAProcessor {
    @BuildStep
    FeatureBuildItem registerFeature() {
        return new FeatureBuildItem("spring-data-jpa");
    }

    @BuildStep
    IgnorableNonIndexedClasses ignorable() {
        HashSet<String> ignorable = new HashSet<String>();
        ignorable.add(Auditable.class.getName());
        ignorable.add(Persistable.class.getName());
        return new IgnorableNonIndexedClasses(ignorable);
    }

    @BuildStep
    void build(CombinedIndexBuildItem index, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        IndexView indexIndex = index.getIndex();
        List<ClassInfo> interfacesExtendingCrudRepository = this.getAllInterfacesExtending(DotNames.SUPPORTED_REPOSITORIES, indexIndex);
        this.removeNoRepositoryBeanClasses(interfacesExtendingCrudRepository);
        this.implementCrudRepositories(generatedBeans, additionalBeans, interfacesExtendingCrudRepository, indexIndex);
    }

    private void removeNoRepositoryBeanClasses(List<ClassInfo> interfacesExtendingCrudRepository) {
        Iterator<ClassInfo> iterator = interfacesExtendingCrudRepository.iterator();
        while (iterator.hasNext()) {
            ClassInfo next = iterator.next();
            if (next.classAnnotation(DotNames.SPRING_DATA_NO_REPOSITORY_BEAN) == null) continue;
            iterator.remove();
        }
    }

    private List<ClassInfo> getAllInterfacesExtending(Collection<DotName> targets, IndexView index) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        Collection knownClasses = index.getKnownClasses();
        for (ClassInfo clazz : knownClasses) {
            if (!Modifier.isInterface(clazz.flags())) continue;
            List interfaceNames = clazz.interfaceNames();
            boolean found = false;
            for (DotName interfaceName : interfaceNames) {
                if (!targets.contains(interfaceName)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            result.add(clazz);
        }
        return result;
    }

    private void implementCrudRepositories(BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalBeanBuildItem> additionalBeans, List<ClassInfo> crudRepositoriesToImplement, IndexView index) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        Indexer indexer = new Indexer();
        HashSet<DotName> additionalIndex = new HashSet<DotName>();
        this.indexRepositoryInterface(index, indexer, additionalIndex, Repository.class);
        this.indexRepositoryInterface(index, indexer, additionalIndex, CrudRepository.class);
        this.indexRepositoryInterface(index, indexer, additionalIndex, PagingAndSortingRepository.class);
        this.indexRepositoryInterface(index, indexer, additionalIndex, JpaRepository.class);
        this.indexRepositoryInterface(index, indexer, additionalIndex, QueryByExampleExecutor.class);
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{index, indexer.complete()});
        SpringDataRepositoryCreator repositoryCreator = new SpringDataRepositoryCreator((ClassOutput)classOutput, (IndexView)compositeIndex, n -> additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)n)));
        for (ClassInfo crudRepositoryToImplement : crudRepositoriesToImplement) {
            repositoryCreator.implementCrudRepository(crudRepositoryToImplement);
        }
    }

    private void indexRepositoryInterface(IndexView index, Indexer indexer, Set<DotName> additionalIndex, Class<?> repoClass) {
        IndexingUtil.indexClass((String)repoClass.getName(), (Indexer)indexer, (IndexView)index, additionalIndex, (ClassLoader)SpringDataJPAProcessor.class.getClassLoader());
    }
}

