package io.qt.opengl;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class <code>QOpenGLVersionStatus</code></p>
 */
public class QOpenGLVersionStatus extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QOpenGLVersionStatus::OpenGLStatus</code></p>
     */
    public enum OpenGLStatus implements QtEnumerator {
        /**
         * <p>Representing <code>QOpenGLVersionStatus::<wbr/>CoreStatus</code></p>
         */
        CoreStatus(0),
        /**
         * <p>Representing <code>QOpenGLVersionStatus::<wbr/>DeprecatedStatus</code></p>
         */
        DeprecatedStatus(1),
        /**
         * <p>Representing <code>QOpenGLVersionStatus::<wbr/>InvalidStatus</code></p>
         */
        InvalidStatus(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private OpenGLStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull OpenGLStatus resolve(int value) {
            switch (value) {
            case 0: return CoreStatus;
            case 1: return DeprecatedStatus;
            case 2: return InvalidStatus;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QOpenGLVersionStatus::<wbr/>QOpenGLVersionStatus()</code></p>
     */
    public QOpenGLVersionStatus(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLVersionStatus instance);
    
    /**
     * <p>See <code>QOpenGLVersionStatus::<wbr/>QOpenGLVersionStatus(QOpenGLVersionStatus)</code></p>
     */
    public QOpenGLVersionStatus(io.qt.opengl.@NonNull QOpenGLVersionStatus other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QOpenGLVersionStatus instance, io.qt.opengl.QOpenGLVersionStatus other);
    
    /**
     * <p>See <code>QOpenGLVersionStatus::<wbr/>QOpenGLVersionStatus(int,<wbr/>int,<wbr/>QOpenGLVersionStatus::OpenGLStatus)</code></p>
     */
    public QOpenGLVersionStatus(int majorVersion, int minorVersion, io.qt.opengl.QOpenGLVersionStatus.@NonNull OpenGLStatus functionStatus){
        super((QPrivateConstructor)null);
        initialize_native(this, majorVersion, minorVersion, functionStatus);
    }
    
    private native static void initialize_native(QOpenGLVersionStatus instance, int majorVersion, int minorVersion, io.qt.opengl.QOpenGLVersionStatus.OpenGLStatus functionStatus);
    
    /**
     * <p>See <code>operator==(QOpenGLVersionStatus,<wbr/>QOpenGLVersionStatus)</code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.opengl.@NonNull QOpenGLVersionStatus rhs){
        return equals_native_cref_QOpenGLVersionStatus(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QOpenGLVersionStatus(long __this__nativeId, long rhs);
    
    /**
     * <p>See <code>QOpenGLVersionStatus::<wbr/>status</code></p>
     */
    @QtUninvokable
    public final void setStatus(io.qt.opengl.QOpenGLVersionStatus.@NonNull OpenGLStatus status){
        setStatus_native_cref_QOpenGLVersionStatus_OpenGLStatus(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @QtUninvokable
    private native void setStatus_native_cref_QOpenGLVersionStatus_OpenGLStatus(long __this__nativeId, int status);
    
    /**
     * <p>See <code>QOpenGLVersionStatus::<wbr/>status</code></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLVersionStatus.@NonNull OpenGLStatus status(){
        return io.qt.opengl.QOpenGLVersionStatus.OpenGLStatus.resolve(status_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLVersionStatus::<wbr/>version</code></p>
     */
    @QtUninvokable
    public final void setVersion(io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> version){
        setVersion_native_cref_QPair(QtJambi_LibraryUtilities.internal.nativeId(this), version);
    }
    
    @QtUninvokable
    private native void setVersion_native_cref_QPair(long __this__nativeId, io.qt.core.QPair<java.lang.@QtPrimitiveType Integer, java.lang.@QtPrimitiveType Integer> version);
    
    /**
     * <p>See <code>QOpenGLVersionStatus::<wbr/>version</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> version(){
        return version_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPair<java.lang.@QtPrimitiveType Integer, java.lang.@QtPrimitiveType Integer> version_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLVersionStatus(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator==(QOpenGLVersionStatus,<wbr/>QOpenGLVersionStatus)</code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.opengl.QOpenGLVersionStatus) {
            return equals((io.qt.opengl.QOpenGLVersionStatus) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QOpenGLVersionStatus)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code>QOpenGLVersionStatus::<wbr/>QOpenGLVersionStatus(QOpenGLVersionStatus)</code></p>
     */
    @QtUninvokable
    @Override
    public QOpenGLVersionStatus clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOpenGLVersionStatus clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLVersionStatus.@NonNull OpenGLStatus getStatus() {
        return status();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #version()} instead.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> getVersion() {
        return version();
    }
}
