package io.qt.opengl;

import io.qt.*;


/**
 * <p>Allows OpenGL shader programs to be linked and used</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html">QOpenGLShaderProgram</a></code></p>
 */
public class QOpenGLShaderProgram extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcSharers;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLShaderProgram.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#QOpenGLShaderProgram">QOpenGLShaderProgram::<wbr/>QOpenGLShaderProgram(QObject*)</a></code></p>
     */
    public QOpenGLShaderProgram(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOpenGLShaderProgram instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addCacheableShaderFromSourceCode-1">QOpenGLShaderProgram::<wbr/>addCacheableShaderFromSourceCode(QOpenGLShader::ShaderType,<wbr/>QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final boolean addCacheableShaderFromSourceCode(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, io.qt.core.@NonNull QByteArray source){
        return addCacheableShaderFromSourceCode_native_QOpenGLShader_ShaderType_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native boolean addCacheableShaderFromSourceCode_native_QOpenGLShader_ShaderType_cref_QByteArray(long __this__nativeId, int type, long source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addCacheableShaderFromSourceCode-2">QOpenGLShaderProgram::<wbr/>addCacheableShaderFromSourceCode(QOpenGLShader::ShaderType,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean addCacheableShaderFromSourceCode(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, java.lang.@NonNull String source){
        return addCacheableShaderFromSourceCode_native_QOpenGLShader_ShaderType_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), source);
    }
    
    @QtUninvokable
    private native boolean addCacheableShaderFromSourceCode_native_QOpenGLShader_ShaderType_cref_QString(long __this__nativeId, int type, java.lang.String source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addCacheableShaderFromSourceFile">QOpenGLShaderProgram::<wbr/>addCacheableShaderFromSourceFile(QOpenGLShader::ShaderType,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean addCacheableShaderFromSourceFile(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, java.lang.@NonNull String fileName){
        return addCacheableShaderFromSourceFile_native_QOpenGLShader_ShaderType_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), fileName);
    }
    
    @QtUninvokable
    private native boolean addCacheableShaderFromSourceFile_native_QOpenGLShader_ShaderType_cref_QString(long __this__nativeId, int type, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addShader">QOpenGLShaderProgram::<wbr/>addShader(QOpenGLShader*)</a></code></p>
     */
    @QtUninvokable
    public final boolean addShader(io.qt.opengl.@Nullable QOpenGLShader shader){
        boolean __qt_return_value = addShader_native_QOpenGLShader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(shader));
        if (shader != null) {
            if(__rcSharers==null)
                __rcSharers = QtJambi_LibraryUtilities.internal.newRCList();
            __rcSharers.add(shader);
        }
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native boolean addShader_native_QOpenGLShader_ptr(long __this__nativeId, long shader);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addShaderFromSourceCode-1">QOpenGLShaderProgram::<wbr/>addShaderFromSourceCode(QOpenGLShader::ShaderType,<wbr/>QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final boolean addShaderFromSourceCode(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, io.qt.core.@NonNull QByteArray source){
        return addShaderFromSourceCode_native_QOpenGLShader_ShaderType_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native boolean addShaderFromSourceCode_native_QOpenGLShader_ShaderType_cref_QByteArray(long __this__nativeId, int type, long source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addShaderFromSourceCode-2">QOpenGLShaderProgram::<wbr/>addShaderFromSourceCode(QOpenGLShader::ShaderType,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean addShaderFromSourceCode(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, java.lang.@NonNull String source){
        return addShaderFromSourceCode_native_QOpenGLShader_ShaderType_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), source);
    }
    
    @QtUninvokable
    private native boolean addShaderFromSourceCode_native_QOpenGLShader_ShaderType_cref_QString(long __this__nativeId, int type, java.lang.String source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addShaderFromSourceFile">QOpenGLShaderProgram::<wbr/>addShaderFromSourceFile(QOpenGLShader::ShaderType,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean addShaderFromSourceFile(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, java.lang.@NonNull String fileName){
        return addShaderFromSourceFile_native_QOpenGLShader_ShaderType_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), fileName);
    }
    
    @QtUninvokable
    private native boolean addShaderFromSourceFile_native_QOpenGLShader_ShaderType_cref_QString(long __this__nativeId, int type, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#attributeLocation-1">QOpenGLShaderProgram::<wbr/>attributeLocation(QByteArray)const</a></code></p>
     */
    @QtUninvokable
    public final int attributeLocation(io.qt.core.@NonNull QByteArray name){
        return attributeLocation_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @QtUninvokable
    private native int attributeLocation_native_cref_QByteArray_constfct(long __this__nativeId, long name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#attributeLocation-2">QOpenGLShaderProgram::<wbr/>attributeLocation(QString)const</a></code></p>
     */
    @QtUninvokable
    public final int attributeLocation(java.lang.@NonNull String name){
        return attributeLocation_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native int attributeLocation_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#bind">QOpenGLShaderProgram::<wbr/>bind()</a></code></p>
     */
    @QtUninvokable
    public final boolean bind(){
        return bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean bind_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#bindAttributeLocation-1">QOpenGLShaderProgram::<wbr/>bindAttributeLocation(QByteArray,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void bindAttributeLocation(io.qt.core.@NonNull QByteArray name, int location){
        bindAttributeLocation_native_cref_QByteArray_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), location);
    }
    
    @QtUninvokable
    private native void bindAttributeLocation_native_cref_QByteArray_int(long __this__nativeId, long name, int location);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#bindAttributeLocation-2">QOpenGLShaderProgram::<wbr/>bindAttributeLocation(QString,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void bindAttributeLocation(java.lang.@NonNull String name, int location){
        bindAttributeLocation_native_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, location);
    }
    
    @QtUninvokable
    private native void bindAttributeLocation_native_cref_QString_int(long __this__nativeId, java.lang.String name, int location);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#create">QOpenGLShaderProgram::<wbr/>create()</a></code></p>
     */
    @QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#defaultInnerTessellationLevels">QOpenGLShaderProgram::<wbr/>defaultInnerTessellationLevels()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Float> defaultInnerTessellationLevels(){
        return defaultInnerTessellationLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Float> defaultInnerTessellationLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#defaultOuterTessellationLevels">QOpenGLShaderProgram::<wbr/>defaultOuterTessellationLevels()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Float> defaultOuterTessellationLevels(){
        return defaultOuterTessellationLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Float> defaultOuterTessellationLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#disableAttributeArray-1">QOpenGLShaderProgram::<wbr/>disableAttributeArray(const char*)</a></code></p>
     */
    @QtUninvokable
    public final void disableAttributeArray(java.lang.@Nullable String name){
        disableAttributeArray_native_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void disableAttributeArray_native_const_char_ptr(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#disableAttributeArray">QOpenGLShaderProgram::<wbr/>disableAttributeArray(int)</a></code></p>
     */
    @QtUninvokable
    public final void disableAttributeArray(int location){
        disableAttributeArray_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), location);
    }
    
    @QtUninvokable
    private native void disableAttributeArray_native_int(long __this__nativeId, int location);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#enableAttributeArray-1">QOpenGLShaderProgram::<wbr/>enableAttributeArray(const char*)</a></code></p>
     */
    @QtUninvokable
    public final void enableAttributeArray(java.lang.@Nullable String name){
        enableAttributeArray_native_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void enableAttributeArray_native_const_char_ptr(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#enableAttributeArray">QOpenGLShaderProgram::<wbr/>enableAttributeArray(int)</a></code></p>
     */
    @QtUninvokable
    public final void enableAttributeArray(int location){
        enableAttributeArray_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), location);
    }
    
    @QtUninvokable
    private native void enableAttributeArray_native_int(long __this__nativeId, int location);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#isLinked">QOpenGLShaderProgram::<wbr/>isLinked()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isLinked(){
        return isLinked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isLinked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#log">QOpenGLShaderProgram::<wbr/>log()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String log(){
        return log_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String log_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#maxGeometryOutputVertices">QOpenGLShaderProgram::<wbr/>maxGeometryOutputVertices()const</a></code></p>
     */
    @QtUninvokable
    public final int maxGeometryOutputVertices(){
        return maxGeometryOutputVertices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxGeometryOutputVertices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#patchVertexCount">QOpenGLShaderProgram::<wbr/>patchVertexCount()const</a></code></p>
     */
    @QtUninvokable
    public final int patchVertexCount(){
        return patchVertexCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int patchVertexCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#programId">QOpenGLShaderProgram::<wbr/>programId()const</a></code></p>
     */
    @QtUninvokable
    public final int programId(){
        return programId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int programId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#release">QOpenGLShaderProgram::<wbr/>release()</a></code></p>
     */
    @QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#removeAllShaders">QOpenGLShaderProgram::<wbr/>removeAllShaders()</a></code></p>
     */
    @QtUninvokable
    public final void removeAllShaders(){
        removeAllShaders_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void removeAllShaders_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#removeShader">QOpenGLShaderProgram::<wbr/>removeShader(QOpenGLShader*)</a></code></p>
     */
    @QtUninvokable
    public final void removeShader(io.qt.opengl.@Nullable QOpenGLShader shader){
        removeShader_native_QOpenGLShader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(shader));
        if (shader != null) {
            while (__rcSharers != null && __rcSharers.remove(shader)) ;
        }
    }
    
    @QtUninvokable
    private native void removeShader_native_QOpenGLShader_ptr(long __this__nativeId, long shader);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-9">QOpenGLShaderProgram::<wbr/>setAttributeArray(const char*,<wbr/>GLenum,<wbr/>const void*,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(java.lang.@Nullable String name, int type, java.nio.@Nullable Buffer values, int tupleSize, int stride){
        setAttributeArray_native_const_char_ptr_GLenum_const_void_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, type, values, tupleSize, stride);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_GLenum_const_void_ptr_int_int(long __this__nativeId, java.lang.String name, int type, java.nio.Buffer values, int tupleSize, int stride);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-5">QOpenGLShaderProgram::<wbr/>setAttributeArray(const char*,<wbr/>const GLfloat*,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(java.lang.@Nullable String name, java.nio.@Nullable FloatBuffer values, int tupleSize, int stride){
        setAttributeArray_native_const_char_ptr_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values, tupleSize, stride);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_const_GLfloat_ptr_int_int(long __this__nativeId, java.lang.String name, java.nio.FloatBuffer values, int tupleSize, int stride);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-6">QOpenGLShaderProgram::<wbr/>setAttributeArray(const char*,<wbr/>const QVector2D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector2D[] values){
        setAttributeArray_native_const_char_ptr_const_QVector2D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_const_QVector2D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector2D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-7">QOpenGLShaderProgram::<wbr/>setAttributeArray(const char*,<wbr/>const QVector3D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector3D[] values){
        setAttributeArray_native_const_char_ptr_const_QVector3D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_const_QVector3D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector3D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-8">QOpenGLShaderProgram::<wbr/>setAttributeArray(const char*,<wbr/>const QVector4D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector4D[] values){
        setAttributeArray_native_const_char_ptr_const_QVector4D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_const_QVector4D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector4D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-4">QOpenGLShaderProgram::<wbr/>setAttributeArray(int,<wbr/>GLenum,<wbr/>const void*,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(int location, int type, java.nio.@Nullable Buffer values, int tupleSize, int stride){
        setAttributeArray_native_int_GLenum_const_void_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, type, values, tupleSize, stride);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_int_GLenum_const_void_ptr_int_int(long __this__nativeId, int location, int type, java.nio.Buffer values, int tupleSize, int stride);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray">QOpenGLShaderProgram::<wbr/>setAttributeArray(int,<wbr/>const GLfloat*,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(int location, java.nio.@Nullable FloatBuffer values, int tupleSize, int stride){
        setAttributeArray_native_int_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values, tupleSize, stride);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_int_const_GLfloat_ptr_int_int(long __this__nativeId, int location, java.nio.FloatBuffer values, int tupleSize, int stride);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-1">QOpenGLShaderProgram::<wbr/>setAttributeArray(int,<wbr/>const QVector2D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(int location, io.qt.gui.@NonNull QVector2D[] values){
        setAttributeArray_native_int_const_QVector2D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_int_const_QVector2D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector2D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-2">QOpenGLShaderProgram::<wbr/>setAttributeArray(int,<wbr/>const QVector3D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(int location, io.qt.gui.@NonNull QVector3D[] values){
        setAttributeArray_native_int_const_QVector3D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_int_const_QVector3D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector3D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeArray-3">QOpenGLShaderProgram::<wbr/>setAttributeArray(int,<wbr/>const QVector4D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeArray(int location, io.qt.gui.@NonNull QVector4D[] values){
        setAttributeArray_native_int_const_QVector4D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setAttributeArray_native_int_const_QVector4D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector4D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeBuffer-1">QOpenGLShaderProgram::<wbr/>setAttributeBuffer(const char*,<wbr/>GLenum,<wbr/>int,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeBuffer(java.lang.@Nullable String name, int type, int offset, int tupleSize, int stride){
        setAttributeBuffer_native_const_char_ptr_GLenum_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, type, offset, tupleSize, stride);
    }
    
    @QtUninvokable
    private native void setAttributeBuffer_native_const_char_ptr_GLenum_int_int_int(long __this__nativeId, java.lang.String name, int type, int offset, int tupleSize, int stride);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeBuffer">QOpenGLShaderProgram::<wbr/>setAttributeBuffer(int,<wbr/>GLenum,<wbr/>int,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeBuffer(int location, int type, int offset, int tupleSize, int stride){
        setAttributeBuffer_native_int_GLenum_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, type, offset, tupleSize, stride);
    }
    
    @QtUninvokable
    private native void setAttributeBuffer_native_int_GLenum_int_int_int(long __this__nativeId, int location, int type, int offset, int tupleSize, int stride);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-9">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, float value){
        setAttributeValue_native_const_char_ptr_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_GLfloat(long __this__nativeId, java.lang.String name, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-10">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, float x, float y){
        setAttributeValue_native_const_char_ptr_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-11">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, float x, float y, float z){
        setAttributeValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y, z);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y, float z);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-12">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, float x, float y, float z, float w){
        setAttributeValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y, z, w);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y, float z, float w);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-16">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>QColor)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QColor value){
        setAttributeValue_native_const_char_ptr_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_cref_QColor(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-13">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>QVector2D)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector2D value){
        setAttributeValue_native_const_char_ptr_cref_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_cref_QVector2D(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-14">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>QVector3D)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector3D value){
        setAttributeValue_native_const_char_ptr_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_cref_QVector3D(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-15">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>QVector4D)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector4D value){
        setAttributeValue_native_const_char_ptr_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_cref_QVector4D(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-17">QOpenGLShaderProgram::<wbr/>setAttributeValue(const char*,<wbr/>const GLfloat*,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, java.nio.@Nullable FloatBuffer values, int columns, int rows){
        setAttributeValue_native_const_char_ptr_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values, columns, rows);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_const_GLfloat_ptr_int_int(long __this__nativeId, java.lang.String name, java.nio.FloatBuffer values, int columns, int rows);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, float value){
        setAttributeValue_native_int_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, value);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_GLfloat(long __this__nativeId, int location, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-1">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, float x, float y){
        setAttributeValue_native_int_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-2">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, float x, float y, float z){
        setAttributeValue_native_int_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-3">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, float x, float y, float z, float w){
        setAttributeValue_native_int_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z, float w);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-7">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>QColor)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.@NonNull QColor value){
        setAttributeValue_native_int_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_cref_QColor(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-4">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>QVector2D)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.@NonNull QVector2D value){
        setAttributeValue_native_int_cref_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_cref_QVector2D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-5">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>QVector3D)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.@NonNull QVector3D value){
        setAttributeValue_native_int_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_cref_QVector3D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-6">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>QVector4D)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.@NonNull QVector4D value){
        setAttributeValue_native_int_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_cref_QVector4D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-8">QOpenGLShaderProgram::<wbr/>setAttributeValue(int,<wbr/>const GLfloat*,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, java.nio.@Nullable FloatBuffer values, int columns, int rows){
        setAttributeValue_native_int_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values, columns, rows);
    }
    
    @QtUninvokable
    private native void setAttributeValue_native_int_const_GLfloat_ptr_int_int(long __this__nativeId, int location, java.nio.FloatBuffer values, int columns, int rows);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setDefaultInnerTessellationLevels">QOpenGLShaderProgram::<wbr/>setDefaultInnerTessellationLevels(QList&lt;float&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setDefaultInnerTessellationLevels(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Float> levels){
        setDefaultInnerTessellationLevels_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), levels);
    }
    
    @QtUninvokable
    private native void setDefaultInnerTessellationLevels_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Float> levels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setDefaultOuterTessellationLevels">QOpenGLShaderProgram::<wbr/>setDefaultOuterTessellationLevels(QList&lt;float&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setDefaultOuterTessellationLevels(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Float> levels){
        setDefaultOuterTessellationLevels_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), levels);
    }
    
    @QtUninvokable
    private native void setDefaultOuterTessellationLevels_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Float> levels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setPatchVertexCount">QOpenGLShaderProgram::<wbr/>setPatchVertexCount(int)</a></code></p>
     */
    @QtUninvokable
    public final void setPatchVertexCount(int count){
        setPatchVertexCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    @QtUninvokable
    private native void setPatchVertexCount_native_int(long __this__nativeId, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-27">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, float value){
        setUniformValue_native_const_char_ptr_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLfloat(long __this__nativeId, java.lang.String name, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-30">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, float x, float y){
        setUniformValue_native_const_char_ptr_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-31">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, float x, float y, float z){
        setUniformValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y, z);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y, float z);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-32">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, float x, float y, float z, float w){
        setUniformValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y, z, w);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y, float z, float w);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-28">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>GLint)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, int value){
        setUniformValue_native_const_char_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLint(long __this__nativeId, java.lang.String name, int value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-36">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QColor)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QColor color){
        setUniformValue_native_const_char_ptr_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QColor(long __this__nativeId, java.lang.String name, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-41">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix2x2)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix2x2 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix2x2(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix2x2(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-42">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix2x3)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix2x3 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix2x3(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix2x3(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-43">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix2x4)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix2x4 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix2x4(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix2x4(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-44">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix3x2)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix3x2 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix3x2(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix3x2(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-45">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix3x3)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix3x3 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix3x3(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix3x3(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-46">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix3x4)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix3x4 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix3x4(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix3x4(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-47">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix4x2)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix4x2 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix4x2(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix4x2(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-48">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix4x3)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix4x3 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix4x3(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix4x3(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-49">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QMatrix4x4)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix4x4 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix4x4(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-37">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QPoint)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.core.@NonNull QPoint point){
        setUniformValue_native_const_char_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QPoint(long __this__nativeId, java.lang.String name, long point);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-38">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QPointF)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.core.@NonNull QPointF point){
        setUniformValue_native_const_char_ptr_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QPointF(long __this__nativeId, java.lang.String name, long point);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-39">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QSize)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.core.@NonNull QSize size){
        setUniformValue_native_const_char_ptr_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QSize(long __this__nativeId, java.lang.String name, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-40">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QSizeF)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.core.@NonNull QSizeF size){
        setUniformValue_native_const_char_ptr_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QSizeF(long __this__nativeId, java.lang.String name, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-53">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QTransform)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QTransform value){
        setUniformValue_native_const_char_ptr_cref_QTransform(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QTransform(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-33">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QVector2D)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector2D value){
        setUniformValue_native_const_char_ptr_cref_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QVector2D(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-34">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QVector3D)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector3D value){
        setUniformValue_native_const_char_ptr_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QVector3D(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-35">QOpenGLShaderProgram::<wbr/>setUniformValue(const char*,<wbr/>QVector4D)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector4D value){
        setUniformValue_native_const_char_ptr_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QVector4D(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, float value){
        setUniformValue_native_int_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, value);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_GLfloat(long __this__nativeId, int location, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-3">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, float x, float y){
        setUniformValue_native_int_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-4">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, float x, float y, float z){
        setUniformValue_native_int_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-5">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, float x, float y, float z, float w){
        setUniformValue_native_int_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z, float w);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-1">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>GLint)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, int value){
        setUniformValue_native_int_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, value);
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_GLint(long __this__nativeId, int location, int value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-9">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QColor)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QColor color){
        setUniformValue_native_int_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QColor(long __this__nativeId, int location, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-14">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix2x2)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix2x2 value){
        setUniformValue_native_int_cref_QMatrix2x2(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix2x2(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-15">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix2x3)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix2x3 value){
        setUniformValue_native_int_cref_QMatrix2x3(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix2x3(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-16">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix2x4)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix2x4 value){
        setUniformValue_native_int_cref_QMatrix2x4(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix2x4(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-17">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix3x2)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix3x2 value){
        setUniformValue_native_int_cref_QMatrix3x2(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix3x2(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-18">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix3x3)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix3x3 value){
        setUniformValue_native_int_cref_QMatrix3x3(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix3x3(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-19">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix3x4)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix3x4 value){
        setUniformValue_native_int_cref_QMatrix3x4(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix3x4(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-20">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix4x2)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix4x2 value){
        setUniformValue_native_int_cref_QMatrix4x2(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix4x2(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-21">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix4x3)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix4x3 value){
        setUniformValue_native_int_cref_QMatrix4x3(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix4x3(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-22">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QMatrix4x4)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QMatrix4x4 value){
        setUniformValue_native_int_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix4x4(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-10">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QPoint)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.core.@NonNull QPoint point){
        setUniformValue_native_int_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QPoint(long __this__nativeId, int location, long point);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-11">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QPointF)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.core.@NonNull QPointF point){
        setUniformValue_native_int_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QPointF(long __this__nativeId, int location, long point);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-12">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QSize)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.core.@NonNull QSize size){
        setUniformValue_native_int_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QSize(long __this__nativeId, int location, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-13">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QSizeF)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.core.@NonNull QSizeF size){
        setUniformValue_native_int_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QSizeF(long __this__nativeId, int location, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-26">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QTransform)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QTransform value){
        setUniformValue_native_int_cref_QTransform(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QTransform(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-6">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QVector2D)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QVector2D value){
        setUniformValue_native_int_cref_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QVector2D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-7">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QVector3D)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QVector3D value){
        setUniformValue_native_int_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QVector3D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-8">QOpenGLShaderProgram::<wbr/>setUniformValue(int,<wbr/>QVector4D)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QVector4D value){
        setUniformValue_native_int_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setUniformValue_native_int_cref_QVector4D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-15">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const GLfloat*,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, java.nio.@Nullable FloatBuffer values, int count, int tupleSize){
        setUniformValueArray_native_const_char_ptr_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values, count, tupleSize);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_GLfloat_ptr_int_int(long __this__nativeId, java.lang.String name, java.nio.FloatBuffer values, int count, int tupleSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-16">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const GLint*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, java.nio.@Nullable IntBuffer values, int count){
        setUniformValueArray_native_const_char_ptr_const_GLint_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values, count);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_GLint_ptr_int(long __this__nativeId, java.lang.String name, java.nio.IntBuffer values, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-21">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix2x2*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix2x2[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix2x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix2x2_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix2x2[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-22">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix2x3*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix2x3[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix2x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix2x3_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix2x3[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-23">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix2x4*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix2x4[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix2x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix2x4_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix2x4[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-24">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix3x2*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix3x2[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix3x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix3x2_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix3x2[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-25">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix3x3*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix3x3[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix3x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix3x3_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix3x3[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-26">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix3x4*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix3x4[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix3x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix3x4_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix3x4[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-27">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix4x2*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix4x2[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix4x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix4x2_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix4x2[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-28">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix4x3*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix4x3[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix4x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix4x3_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix4x3[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-29">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QMatrix4x4*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QMatrix4x4[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix4x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix4x4_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix4x4[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-18">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QVector2D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector2D[] values){
        setUniformValueArray_native_const_char_ptr_const_QVector2D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QVector2D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector2D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-19">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QVector3D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector3D[] values){
        setUniformValueArray_native_const_char_ptr_const_QVector3D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QVector3D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector3D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-20">QOpenGLShaderProgram::<wbr/>setUniformValueArray(const char*,<wbr/>const QVector4D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(java.lang.@Nullable String name, io.qt.gui.@NonNull QVector4D[] values){
        setUniformValueArray_native_const_char_ptr_const_QVector4D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QVector4D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector4D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const GLfloat*,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, java.nio.@Nullable FloatBuffer values, int count, int tupleSize){
        setUniformValueArray_native_int_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values, count, tupleSize);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_GLfloat_ptr_int_int(long __this__nativeId, int location, java.nio.FloatBuffer values, int count, int tupleSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-1">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const GLint*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, java.nio.@Nullable IntBuffer values, int count){
        setUniformValueArray_native_int_const_GLint_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values, count);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_GLint_ptr_int(long __this__nativeId, int location, java.nio.IntBuffer values, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-6">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix2x2*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix2x2[] values){
        setUniformValueArray_native_int_const_QMatrix2x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix2x2_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix2x2[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-7">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix2x3*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix2x3[] values){
        setUniformValueArray_native_int_const_QMatrix2x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix2x3_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix2x3[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-8">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix2x4*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix2x4[] values){
        setUniformValueArray_native_int_const_QMatrix2x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix2x4_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix2x4[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-9">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix3x2*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix3x2[] values){
        setUniformValueArray_native_int_const_QMatrix3x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix3x2_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix3x2[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-10">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix3x3*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix3x3[] values){
        setUniformValueArray_native_int_const_QMatrix3x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix3x3_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix3x3[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-11">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix3x4*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix3x4[] values){
        setUniformValueArray_native_int_const_QMatrix3x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix3x4_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix3x4[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-12">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix4x2*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix4x2[] values){
        setUniformValueArray_native_int_const_QMatrix4x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix4x2_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix4x2[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-13">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix4x3*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix4x3[] values){
        setUniformValueArray_native_int_const_QMatrix4x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix4x3_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix4x3[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-14">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QMatrix4x4*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QMatrix4x4[] values){
        setUniformValueArray_native_int_const_QMatrix4x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix4x4_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix4x4[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-3">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QVector2D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QVector2D[] values){
        setUniformValueArray_native_int_const_QVector2D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QVector2D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector2D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-4">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QVector3D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QVector3D[] values){
        setUniformValueArray_native_int_const_QVector3D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QVector3D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector3D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValueArray-5">QOpenGLShaderProgram::<wbr/>setUniformValueArray(int,<wbr/>const QVector4D*,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.@NonNull QVector4D[] values){
        setUniformValueArray_native_int_const_QVector4D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @QtUninvokable
    private native void setUniformValueArray_native_int_const_QVector4D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector4D[] values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#shaders">QOpenGLShaderProgram::<wbr/>shaders()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.opengl.@Nullable QOpenGLShader> shaders(){
        return shaders_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.opengl.QOpenGLShader> shaders_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#uniformLocation-1">QOpenGLShaderProgram::<wbr/>uniformLocation(QByteArray)const</a></code></p>
     */
    @QtUninvokable
    public final int uniformLocation(io.qt.core.@NonNull QByteArray name){
        return uniformLocation_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @QtUninvokable
    private native int uniformLocation_native_cref_QByteArray_constfct(long __this__nativeId, long name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#uniformLocation-2">QOpenGLShaderProgram::<wbr/>uniformLocation(QString)const</a></code></p>
     */
    @QtUninvokable
    public final int uniformLocation(java.lang.@NonNull String name){
        return uniformLocation_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native int uniformLocation_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#link">QOpenGLShaderProgram::<wbr/>link()</a></code></p>
     */
    @QtUninvokable
    public boolean link(){
        return link_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean link_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshaderprogram.html#hasOpenGLShaderPrograms">QOpenGLShaderProgram::<wbr/>hasOpenGLShaderPrograms(QOpenGLContext*)</a></code></p>
     */
    public static boolean hasOpenGLShaderPrograms(io.qt.gui.@Nullable QOpenGLContext context){
        return hasOpenGLShaderPrograms_native_QOpenGLContext_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    private native static boolean hasOpenGLShaderPrograms_native_QOpenGLContext_ptr(long context);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLShaderProgram(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLShaderProgram(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QOpenGLShaderProgram instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLShaderProgram(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLShaderProgram() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #addCacheableShaderFromSourceCode(io.qt.opengl.QOpenGLShader.ShaderType, io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final boolean addCacheableShaderFromSourceCode(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, byte @NonNull[] source) {
        return addCacheableShaderFromSourceCode(type, new io.qt.core.QByteArray(source));
    }
    
    /**
     * <p>Overloaded function for {@link #addShaderFromSourceCode(io.qt.opengl.QOpenGLShader.ShaderType, io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final boolean addShaderFromSourceCode(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, byte @NonNull[] source) {
        return addShaderFromSourceCode(type, new io.qt.core.QByteArray(source));
    }
    
    /**
     * <p>Overloaded function for {@link #attributeLocation(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final int attributeLocation(byte @NonNull[] name) {
        return attributeLocation(new io.qt.core.QByteArray(name));
    }
    
    /**
     * <p>Overloaded function for {@link #bindAttributeLocation(io.qt.core.QByteArray, int)}.</p>
     */
    @QtUninvokable
    public final void bindAttributeLocation(byte @NonNull[] name, int location) {
        bindAttributeLocation(new io.qt.core.QByteArray(name), location);
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeArray(java.lang.String, int, java.nio.Buffer, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @QtUninvokable
    public final void setAttributeArray(java.lang.@Nullable String name, int type, java.nio.@Nullable Buffer values, int tupleSize) {
        setAttributeArray(name, type, values, tupleSize, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeArray(java.lang.String, java.nio.FloatBuffer, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @QtUninvokable
    public final void setAttributeArray(java.lang.@Nullable String name, java.nio.@Nullable FloatBuffer values, int tupleSize) {
        setAttributeArray(name, values, tupleSize, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeArray(int, int, java.nio.Buffer, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @QtUninvokable
    public final void setAttributeArray(int location, int type, java.nio.@Nullable Buffer values, int tupleSize) {
        setAttributeArray(location, type, values, tupleSize, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeArray(int, java.nio.FloatBuffer, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @QtUninvokable
    public final void setAttributeArray(int location, java.nio.@Nullable FloatBuffer values, int tupleSize) {
        setAttributeArray(location, values, tupleSize, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeBuffer(java.lang.String, int, int, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @QtUninvokable
    public final void setAttributeBuffer(java.lang.@Nullable String name, int type, int offset, int tupleSize) {
        setAttributeBuffer(name, type, offset, tupleSize, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeBuffer(int, int, int, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @QtUninvokable
    public final void setAttributeBuffer(int location, int type, int offset, int tupleSize) {
        setAttributeBuffer(location, type, offset, tupleSize, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeValue(java.lang.String, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, io.qt.core.Qt.@NonNull GlobalColor value) {
        setAttributeValue(name, new io.qt.gui.QColor(value));
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeValue(java.lang.String, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QRgba64 value) {
        setAttributeValue(name, new io.qt.gui.QColor(value));
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeValue(java.lang.String, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setAttributeValue(java.lang.@Nullable String name, java.lang.@NonNull String value) {
        setAttributeValue(name, new io.qt.gui.QColor(value));
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeValue(int, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, io.qt.core.Qt.@NonNull GlobalColor value) {
        setAttributeValue(location, new io.qt.gui.QColor(value));
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeValue(int, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.@NonNull QRgba64 value) {
        setAttributeValue(location, new io.qt.gui.QColor(value));
    }
    
    /**
     * <p>Overloaded function for {@link #setAttributeValue(int, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setAttributeValue(int location, java.lang.@NonNull String value) {
        setAttributeValue(location, new io.qt.gui.QColor(value));
    }
    
    /**
     * <p>Overloaded function for {@link #setUniformValue(java.lang.String, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.core.Qt.@NonNull GlobalColor color) {
        setUniformValue(name, new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setUniformValue(java.lang.String, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, io.qt.gui.@NonNull QRgba64 color) {
        setUniformValue(name, new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setUniformValue(java.lang.String, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setUniformValue(java.lang.@Nullable String name, java.lang.@NonNull String color) {
        setUniformValue(name, new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setUniformValue(int, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.core.Qt.@NonNull GlobalColor color) {
        setUniformValue(location, new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setUniformValue(int, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.@NonNull QRgba64 color) {
        setUniformValue(location, new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setUniformValue(int, io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setUniformValue(int location, java.lang.@NonNull String color) {
        setUniformValue(location, new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #uniformLocation(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final int uniformLocation(byte @NonNull[] name) {
        return uniformLocation(new io.qt.core.QByteArray(name));
    }
    
    /**
     * <p>Overloaded function for {@link #hasOpenGLShaderPrograms(io.qt.gui.QOpenGLContext)}
     *  with <code>context = null</code>.</p>
     */
    public static boolean hasOpenGLShaderPrograms() {
        return hasOpenGLShaderPrograms((io.qt.gui.QOpenGLContext)null);
    }
}
