#include <QtCore/QtGlobal>
#include <QtOpenGL/qopenglbuffer.h>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/JavaAPI>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QOpenGLBuffer(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QOpenGLBuffer")
    QOpenGLBuffer *_ptr = reinterpret_cast<QOpenGLBuffer *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QOpenGLBuffer()
void __qt_construct_QOpenGLBuffer(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, QtJambiAPI::ConstructorOptions __qtjambi_constructor_options)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLBuffer()")
    Q_UNUSED(__java_arguments)
    QOpenGLBuffer *__qt_this;
    __qt_this = new(__qtjambi_ptr) QOpenGLBuffer();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qtjambi_constructor_options)
}

// QOpenGLBuffer::QOpenGLBuffer()
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_initialize_1native__Lio_qt_opengl_QOpenGLBuffer_2
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLBuffer::QOpenGLBuffer()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLBuffer, sizeof(QOpenGLBuffer), typeid(QOpenGLBuffer), 0, false, &deleter_QOpenGLBuffer);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLBuffer(QOpenGLBuffer)
void __qt_construct_QOpenGLBuffer_cref_QOpenGLBuffer(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, QtJambiAPI::ConstructorOptions __qtjambi_constructor_options)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLBuffer(QOpenGLBuffer)")
    jobject other0 = __java_arguments[0].l;
    const QOpenGLBuffer& __qt_other0 = qtjambi_cast<const QOpenGLBuffer&>(__jni_env, other0);
    QOpenGLBuffer *__qt_this;
    __qt_this = new(__qtjambi_ptr) QOpenGLBuffer(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qtjambi_constructor_options)
}

// QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_initialize_1native__Lio_qt_opengl_QOpenGLBuffer_2Lio_qt_opengl_QOpenGLBuffer_2
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLBuffer_cref_QOpenGLBuffer, sizeof(QOpenGLBuffer), typeid(QOpenGLBuffer), 0, false, &deleter_QOpenGLBuffer, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLBuffer(QOpenGLBuffer::Type)
void __qt_construct_QOpenGLBuffer_QOpenGLBuffer_Type(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, QtJambiAPI::ConstructorOptions __qtjambi_constructor_options)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLBuffer(QOpenGLBuffer::Type)")
    jobject type0 = __java_arguments[0].l;
    QOpenGLBuffer::Type __qt_type0 = qtjambi_cast<QOpenGLBuffer::Type>(__jni_env, type0);
    QOpenGLBuffer *__qt_this;
    __qt_this = new(__qtjambi_ptr) QOpenGLBuffer(QOpenGLBuffer::Type(__qt_type0));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qtjambi_constructor_options)
}

// QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer::Type)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_initialize_1native__Lio_qt_opengl_QOpenGLBuffer_2Lio_qt_opengl_QOpenGLBuffer_00024Type_2
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject type0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer::Type)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = type0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLBuffer_QOpenGLBuffer_Type, sizeof(QOpenGLBuffer), typeid(QOpenGLBuffer), 0, false, &deleter_QOpenGLBuffer, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QOpenGLBuffer
void __qt_destruct_QOpenGLBuffer(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QOpenGLBuffer")
    reinterpret_cast<QOpenGLBuffer*>(ptr)->~QOpenGLBuffer();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QOpenGLBuffer::allocate(const void*,int)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_allocate_1native_1const_1void_1ptr_1int__JLjava_nio_Buffer_2I
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject data0,
 jint count1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::allocate(const void*,int)", __this_nativeId)
        JBufferConstData __qt_data0_buffer(__jni_env, data0);
        const void* __qt_data0 = __qt_data0_buffer.data<void>();
        __qt_this->allocate(__qt_data0, static_cast<int>(count1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLBuffer::allocate(int)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_allocate_1native_1int__JI
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint count0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::allocate(int)", __this_nativeId)
        __qt_this->allocate(static_cast<int>(count0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLBuffer::bind()
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLBuffer_bind_1native__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::bind()", __this_nativeId)
        __java_return_value = __qt_this->bind();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::bufferId()const
extern "C" JNIEXPORT jint JNICALL Java_io_qt_opengl_QOpenGLBuffer_bufferId_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::bufferId()const", __this_nativeId)
        GLuint __qt_return_value = __qt_this->bufferId();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::create()
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLBuffer_create_1native__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::create()", __this_nativeId)
        __java_return_value = __qt_this->create();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::destroy()
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_destroy_1native__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::destroy()", __this_nativeId)
        __qt_this->destroy();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLBuffer::isCreated()const
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLBuffer_isCreated_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::isCreated()const", __this_nativeId)
        __java_return_value = __qt_this->isCreated();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::map(QOpenGLBuffer::Access)
extern "C" JNIEXPORT jobject JNICALL Java_io_qt_opengl_QOpenGLBuffer_map_1native_1QOpenGLBuffer_1Access__JI
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint access0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::map(QOpenGLBuffer::Access)", __this_nativeId)
        QOpenGLBuffer::Access __qt_access0 = qtjambi_cast<QOpenGLBuffer::Access>(__jni_env, access0);
        void* __qt_return_value = __qt_this->map(QOpenGLBuffer::Access(__qt_access0));
        DataJBuffer __java_return_value_buffer(__jni_env, __qt_return_value, __qt_this->size());
        __java_return_value = __java_return_value_buffer.take();
        QtJambiAPI::registerDependency(__jni_env, __java_return_value, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::mapRange(int,int,QOpenGLBuffer::RangeAccessFlags)
extern "C" JNIEXPORT jobject JNICALL Java_io_qt_opengl_QOpenGLBuffer_mapRange_1native_1int_1int_1QOpenGLBuffer_1RangeAccessFlags__JIII
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint offset0,
 jint count1,
 jint access2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::mapRange(int,int,QOpenGLBuffer::RangeAccessFlags)", __this_nativeId)
        QOpenGLBuffer::RangeAccessFlags __qt_access2 = qtjambi_cast<QOpenGLBuffer::RangeAccessFlags>(__jni_env, access2);
        void* __qt_return_value = __qt_this->mapRange(static_cast<int>(offset0), static_cast<int>(count1), QOpenGLBuffer::RangeAccessFlags(__qt_access2));
        DataJBuffer __java_return_value_buffer(__jni_env, __qt_return_value, qMin<qsizetype>(count1, __qt_this->size()-offset0));
        __java_return_value = __java_return_value_buffer.take();
        QtJambiAPI::registerDependency(__jni_env, __java_return_value, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::operator=(QOpenGLBuffer)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_assign_1native_1cref_1QOpenGLBuffer__JJ
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::operator=(QOpenGLBuffer)", __this_nativeId)
        const QOpenGLBuffer& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QOpenGLBuffer>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLBuffer::read(int,void*,int)
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLBuffer_read_1native_1int_1void_1ptr_1int__JILjava_nio_Buffer_2I
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint offset0,
 jobject data1,
 jint count2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::read(int,void*,int)", __this_nativeId)
        JBufferData __qt_data1_buffer(__jni_env, data1);
        void* __qt_data1 = __qt_data1_buffer.data<void>();
        __java_return_value = __qt_this->read(static_cast<int>(offset0), __qt_data1, static_cast<int>(count2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::release()
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_release_1native__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::release()", __this_nativeId)
        __qt_this->release();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLBuffer::setUsagePattern(QOpenGLBuffer::UsagePattern)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_setUsagePattern_1native_1QOpenGLBuffer_1UsagePattern__JI
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint value0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::setUsagePattern(QOpenGLBuffer::UsagePattern)", __this_nativeId)
        QOpenGLBuffer::UsagePattern __qt_value0 = qtjambi_cast<QOpenGLBuffer::UsagePattern>(__jni_env, value0);
        __qt_this->setUsagePattern(QOpenGLBuffer::UsagePattern(__qt_value0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLBuffer::size()const
extern "C" JNIEXPORT jint JNICALL Java_io_qt_opengl_QOpenGLBuffer_size_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::size()const", __this_nativeId)
        __java_return_value = __qt_this->size();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::swap(QOpenGLBuffer&)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_swap_1native_1ref_1QOpenGLBuffer__JJ
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::swap(QOpenGLBuffer&)", __this_nativeId)
        QOpenGLBuffer& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QOpenGLBuffer>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLBuffer::type()const
extern "C" JNIEXPORT jint JNICALL Java_io_qt_opengl_QOpenGLBuffer_type_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::type()const", __this_nativeId)
        QOpenGLBuffer::Type __qt_return_value = __qt_this->type();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::unmap()
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLBuffer_unmap_1native__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::unmap()", __this_nativeId)
        __java_return_value = __qt_this->unmap();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::usagePattern()const
extern "C" JNIEXPORT jint JNICALL Java_io_qt_opengl_QOpenGLBuffer_usagePattern_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::usagePattern()const", __this_nativeId)
        QOpenGLBuffer::UsagePattern __qt_return_value = __qt_this->usagePattern();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLBuffer::write(int,const void*,int)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_write_1native_1int_1const_1void_1ptr_1int__JILjava_nio_Buffer_2I
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint offset0,
 jobject data1,
 jint count2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLBuffer::write(int,const void*,int)", __this_nativeId)
        JBufferConstData __qt_data1_buffer(__jni_env, data1);
        const void* __qt_data1 = __qt_data1_buffer.data<void>();
        __qt_this->write(static_cast<int>(offset0), __qt_data1, static_cast<int>(count2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLBuffer::release(QOpenGLBuffer::Type)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLBuffer_release_1native_1QOpenGLBuffer_1Type__I
(JNIEnv *__jni_env,
 jclass,
 jint type0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLBuffer::release(QOpenGLBuffer::Type)")
    QTJAMBI_TRY {
        QOpenGLBuffer::Type __qt_type0 = qtjambi_cast<QOpenGLBuffer::Type>(__jni_env, type0);
        QOpenGLBuffer::release(QOpenGLBuffer::Type(__qt_type0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" JNIEXPORT jobject JNICALL Java_io_qt_opengl_QOpenGLBuffer_clone_1native
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QOpenGLBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QOpenGLBuffer(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QOpenGLBuffer>("QOpenGLBuffer", "io/qt/opengl/QOpenGLBuffer");
    Q_UNUSED(typeId)
    registerConstructorInfos(typeId, 0, &__qt_destruct_QOpenGLBuffer, {
        ConstructorInfo{&__qt_construct_QOpenGLBuffer, nullptr}
       ,ConstructorInfo{&__qt_construct_QOpenGLBuffer_cref_QOpenGLBuffer, "Lio/qt/opengl/QOpenGLBuffer;"}
       ,ConstructorInfo{&__qt_construct_QOpenGLBuffer_QOpenGLBuffer_Type, "Lio/qt/opengl/QOpenGLBuffer$Type;"}
    });
    registerDeleter(typeId, &deleter_QOpenGLBuffer);
    registerMetaType<QOpenGLBuffer>("QOpenGLBuffer");
    registerEnumTypeInfo<QOpenGLBuffer::Access>("QOpenGLBuffer::Access", "io/qt/opengl/QOpenGLBuffer$Access");
    registerEnumTypeInfo<QOpenGLBuffer::RangeAccessFlag>("QOpenGLBuffer::RangeAccessFlag", "io/qt/opengl/QOpenGLBuffer$RangeAccessFlag", "QOpenGLBuffer::RangeAccessFlags", "QFlags<QOpenGLBuffer::RangeAccessFlag>", "io/qt/opengl/QOpenGLBuffer$RangeAccessFlags");
    registerEnumTypeInfo<QOpenGLBuffer::Type>("QOpenGLBuffer::Type", "io/qt/opengl/QOpenGLBuffer$Type");
    registerEnumTypeInfo<QOpenGLBuffer::UsagePattern>("QOpenGLBuffer::UsagePattern", "io/qt/opengl/QOpenGLBuffer$UsagePattern");
}
