/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.ServiceMethod;
import io.protostuff.compiler.parser.AbstractProtoParserListener;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoParser;
import org.antlr.v4.runtime.BufferedTokenStream;

public class ServiceParseListener
extends AbstractProtoParserListener {
    protected ServiceParseListener(BufferedTokenStream tokens, ProtoContext context) {
        super(tokens, context);
    }

    @Override
    public void enterServiceBlock(ProtoParser.ServiceBlockContext ctx) {
        Proto parent = this.context.peek(Proto.class);
        Service service = new Service(parent);
        this.context.push(service);
    }

    @Override
    public void exitServiceBlock(ProtoParser.ServiceBlockContext ctx) {
        Service service = this.context.pop(Service.class);
        Proto proto = this.context.peek(Proto.class);
        String name = ctx.name().getText();
        service.setName(name);
        service.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        proto.addService(service);
        this.attachComments(ctx, service, false);
    }

    @Override
    public void enterRpcMethod(ProtoParser.RpcMethodContext ctx) {
        Service parent = this.context.peek(Service.class);
        ServiceMethod method = new ServiceMethod(parent);
        this.context.push(method);
    }

    @Override
    public void exitRpcMethod(ProtoParser.RpcMethodContext ctx) {
        ServiceMethod method = this.context.pop(ServiceMethod.class);
        Service service = this.context.peek(Service.class);
        String name = ctx.name().getText();
        String arg = ctx.typeReference(0).getText();
        String ret = ctx.typeReference(1).getText();
        method.setName(name);
        method.setArgTypeName(arg);
        method.setReturnTypeName(ret);
        method.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        service.addMethod(method);
        this.attachComments(ctx, method, true);
    }
}

