/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Extension;
import io.protostuff.compiler.model.ExtensionRange;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.ExtensionRegistry;
import io.protostuff.compiler.parser.ParserException;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoContextPostProcessor;
import java.util.List;

public class ExtensionRegistratorPostProcessor
implements ProtoContextPostProcessor {
    @Override
    public void process(ProtoContext context) {
        this.registerExtensions(context, context.getProto());
    }

    private void registerExtensions(ProtoContext context, UserTypeContainer container) {
        ExtensionRegistry extensionRegistry = context.getExtensionRegistry();
        List<Extension> extensions = container.getDeclaredExtensions();
        for (Extension extension : extensions) {
            Message extendee = extension.getExtendee();
            List<ExtensionRange> ranges = extendee.getExtensionRanges();
            List<Field> fields = extension.getFields();
            for (Field field : fields) {
                int tag = field.getTag();
                boolean inRange = false;
                for (ExtensionRange range : ranges) {
                    int min = range.getMin();
                    int max = range.getMax();
                    if (tag < min || tag > max) continue;
                    inRange = true;
                }
                if (inRange) continue;
                String format = "Extension field '%s' tag=%d is out of allowed range";
                throw new ParserException(field, format, field.getName(), tag);
            }
            String parentNamespace = container.getNamespace();
            extension.setNamespace(parentNamespace);
            extensionRegistry.registerExtension(extension);
        }
        for (Message message : container.getMessages()) {
            this.registerExtensions(context, message);
        }
    }
}

