/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.EnumConstant;
import io.protostuff.compiler.model.EnumContainer;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.AbstractProtoParserListener;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoParser;
import org.antlr.v4.runtime.BufferedTokenStream;

public class EnumParseListener
extends AbstractProtoParserListener {
    protected EnumParseListener(BufferedTokenStream tokens, ProtoContext context) {
        super(tokens, context);
    }

    @Override
    public void enterEnumBlock(ProtoParser.EnumBlockContext ctx) {
        UserTypeContainer parent = this.context.peek(UserTypeContainer.class);
        Enum enumBuilder = new Enum(parent);
        this.context.push(enumBuilder);
    }

    @Override
    public void exitEnumBlock(ProtoParser.EnumBlockContext ctx) {
        Enum e = this.context.pop(Enum.class);
        EnumContainer container = this.context.peek(EnumContainer.class);
        String name = ctx.NAME().getText();
        e.setName(name);
        e.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        container.addEnum(e);
        this.attachComments(ctx, e, false);
    }

    @Override
    public void enterEnumConstant(ProtoParser.EnumConstantContext ctx) {
        Enum parent = this.context.peek(Enum.class);
        EnumConstant enumConstant = new EnumConstant(parent);
        this.context.push(enumConstant);
    }

    @Override
    public void exitEnumConstant(ProtoParser.EnumConstantContext ctx) {
        EnumConstant enumConstant = this.context.pop(EnumConstant.class);
        Enum e = this.context.peek(Enum.class);
        String name = ctx.NAME().getText();
        int number = Integer.decode(ctx.INTEGER_VALUE().getText());
        enumConstant.setName(name);
        enumConstant.setValue(number);
        enumConstant.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        e.addConstant(enumConstant);
        this.attachComments(ctx, enumConstant, true);
    }
}

