/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ModuleConfiguration {
    private final String name;
    private final List<Path> includePaths;
    private final List<String> protoFiles;
    private final String template;
    private final String output;
    private final Map<String, String> options;

    private ModuleConfiguration(Builder builder) {
        this.name = builder.name;
        this.includePaths = builder.includePaths;
        this.protoFiles = builder.protoFiles;
        this.template = builder.template;
        this.output = builder.output;
        this.options = builder.options;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ModuleConfiguration copy) {
        Builder builder = new Builder();
        builder.name = copy.name;
        builder.includePaths = copy.includePaths;
        builder.protoFiles = copy.protoFiles;
        builder.template = copy.template;
        builder.output = copy.output;
        builder.options = copy.options;
        return builder;
    }

    public List<String> getProtoFiles() {
        return this.protoFiles;
    }

    public String getName() {
        return this.name;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getOutput() {
        return this.output;
    }

    public List<Path> getIncludePaths() {
        return this.includePaths;
    }

    public Map<String, String> getOptions() {
        if (this.options == null) {
            return Collections.emptyMap();
        }
        return this.options;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("includePaths", this.includePaths).add("protoFiles", this.protoFiles).add("template", (Object)this.template).add("output", (Object)this.output).toString();
    }

    public static final class Builder {
        private String name;
        private List<Path> includePaths;
        private List<String> protoFiles;
        private String template;
        private String output;
        private Map<String, String> options;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder includePaths(List<Path> includePaths) {
            this.includePaths = includePaths;
            return this;
        }

        public Builder protoFiles(List<String> protoFiles) {
            this.protoFiles = protoFiles;
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public Builder output(String output) {
            this.output = output;
            return this;
        }

        public Builder options(Map<String, String> val) {
            this.options = val;
            return this;
        }

        public Builder addProtoFile(String protoFile) {
            if (this.protoFiles == null) {
                this.protoFiles = new ArrayList<String>();
            }
            this.protoFiles.add(protoFile);
            return this;
        }

        public ModuleConfiguration build() {
            return new ModuleConfiguration(this);
        }
    }
}

