/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.protostuff.compiler.model.AbstractUserTypeContainer;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.ExtensionRange;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.Group;
import io.protostuff.compiler.model.GroupContainer;
import io.protostuff.compiler.model.Oneof;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.UserType;
import io.protostuff.compiler.model.UserTypeContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Message
extends AbstractUserTypeContainer
implements UserType,
UserTypeContainer,
FieldContainer,
GroupContainer {
    protected List<Field> fields;
    protected List<Group> groups;
    protected List<Oneof> oneofs;
    protected Proto proto;
    protected String fullyQualifiedName;
    protected List<ExtensionRange> extensionRanges;

    public Message(UserTypeContainer parent) {
        super(parent);
    }

    @Override
    public DescriptorType getDescriptorType() {
        return DescriptorType.MESSAGE;
    }

    @Override
    public List<Field> getFields() {
        if (this.fields == null) {
            return Collections.emptyList();
        }
        return this.fields;
    }

    @Override
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @Override
    public void addField(Field field) {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
        }
        this.fields.add(field);
    }

    @Override
    public Field getField(String name) {
        for (Field field : this.getFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    @Override
    public Field getField(int tag) {
        for (Field field : this.getFields()) {
            if (tag != field.getTag()) continue;
            return field;
        }
        return null;
    }

    public List<Oneof> getOneofs() {
        if (this.oneofs == null) {
            return Collections.emptyList();
        }
        return this.oneofs;
    }

    public void setOneofs(List<Oneof> oneofs) {
        this.oneofs = oneofs;
    }

    public void addOneof(Oneof oneof) {
        if (this.oneofs == null) {
            this.oneofs = new ArrayList<Oneof>();
        }
        this.oneofs.add(oneof);
    }

    public Oneof getOneof(String name) {
        for (Oneof oneof : this.getOneofs()) {
            if (!name.equals(oneof.getName())) continue;
            return oneof;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("fullyQualifiedName", (Object)this.getFullyQualifiedName()).add("fields", this.fields).add("messages", (Object)this.messages).add("enums", (Object)this.enums).add("options", (Object)this.options).toString();
    }

    @Override
    public Proto getProto() {
        return this.proto;
    }

    @Override
    public void setProto(Proto proto) {
        this.proto = proto;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isMessage() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public String getNamespace() {
        Preconditions.checkNotNull((Object)this.fullyQualifiedName, (Object)"message is not initialized");
        return this.fullyQualifiedName + ".";
    }

    @Override
    public List<Group> getGroups() {
        if (this.groups == null) {
            return Collections.emptyList();
        }
        return this.groups;
    }

    @Override
    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @Override
    public void addGroup(Group group) {
        if (this.groups == null) {
            this.groups = new ArrayList<Group>();
        }
        this.groups.add(group);
    }

    public List<ExtensionRange> getExtensionRanges() {
        if (this.extensionRanges == null) {
            return Collections.emptyList();
        }
        return this.extensionRanges;
    }

    public void setExtensionRanges(List<ExtensionRange> extensionRanges) {
        this.extensionRanges = extensionRanges;
    }

    public void addExtensionRange(ExtensionRange range) {
        if (this.extensionRanges == null) {
            this.extensionRanges = new ArrayList<ExtensionRange>();
        }
        this.extensionRanges.add(range);
    }

    @Override
    public int getFieldCount() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.size();
    }

    public boolean isMapEntry() {
        DynamicMessage.Value value = this.getOptions().get(".google.protobuf.map_entry");
        return value != null && value.isBooleanType() && value.getBoolean();
    }
}

