package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ModuleConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableModuleConfiguration.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ModuleConfiguration"})
@Immutable
@CheckReturnValue
public final class ImmutableModuleConfiguration implements ModuleConfiguration {
  private final String name;
  private final ImmutableList<Path> includePaths;
  private final ImmutableList<String> protoFiles;
  private final String generator;
  private final String output;
  private final ImmutableMap<String, Object> options;

  private ImmutableModuleConfiguration(
      String name,
      ImmutableList<Path> includePaths,
      ImmutableList<String> protoFiles,
      String generator,
      String output,
      ImmutableMap<String, Object> options) {
    this.name = name;
    this.includePaths = includePaths;
    this.protoFiles = protoFiles;
    this.generator = generator;
    this.output = output;
    this.options = options;
  }

  /**
   * Module name.
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * List of "include" folders used to search for proto files.
   */
  @Override
  public ImmutableList<Path> getIncludePaths() {
    return includePaths;
  }

  /**
   * List of proto files to compile.
   */
  @Override
  public ImmutableList<String> getProtoFiles() {
    return protoFiles;
  }

  /**
   * Generator used to compile proto files. Currently following generators
   * are supported:
   * <ul>
   *     <li><code>java</code> - produces Java source code that uses protostuff runtime;</li>
   *     <li><code>html</code> - produces HTML documentation;</li>
   *     <li><code>st4</code> - generic generator, you should provide custom template
   *     (StringTemplate 4) using {@linkplain #getOptions()}.
   *     </li>
   * </ul>
   */
  @Override
  public String getGenerator() {
    return generator;
  }

  /**
   * Output directory.
   */
  @Override
  public String getOutput() {
    return output;
  }

  /**
   * Map of custom settings passed to the generator.
   */
  @Override
  public ImmutableMap<String, Object> getOptions() {
    return options;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModuleConfiguration#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModuleConfiguration withName(String value) {
    if (this.name.equals(value)) return this;
    String newValue = Preconditions.checkNotNull(value, "name");
    return new ImmutableModuleConfiguration(newValue, this.includePaths, this.protoFiles, this.generator, this.output, this.options);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ModuleConfiguration#getIncludePaths() includePaths}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableModuleConfiguration withIncludePaths(Path... elements) {
    ImmutableList<Path> newValue = ImmutableList.copyOf(elements);
    return new ImmutableModuleConfiguration(this.name, newValue, this.protoFiles, this.generator, this.output, this.options);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ModuleConfiguration#getIncludePaths() includePaths}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of includePaths elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableModuleConfiguration withIncludePaths(Iterable<? extends Path> elements) {
    if (this.includePaths == elements) return this;
    ImmutableList<Path> newValue = ImmutableList.copyOf(elements);
    return new ImmutableModuleConfiguration(this.name, newValue, this.protoFiles, this.generator, this.output, this.options);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ModuleConfiguration#getProtoFiles() protoFiles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableModuleConfiguration withProtoFiles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableModuleConfiguration(this.name, this.includePaths, newValue, this.generator, this.output, this.options);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ModuleConfiguration#getProtoFiles() protoFiles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of protoFiles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableModuleConfiguration withProtoFiles(Iterable<String> elements) {
    if (this.protoFiles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableModuleConfiguration(this.name, this.includePaths, newValue, this.generator, this.output, this.options);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModuleConfiguration#getGenerator() generator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for generator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModuleConfiguration withGenerator(String value) {
    if (this.generator.equals(value)) return this;
    String newValue = Preconditions.checkNotNull(value, "generator");
    return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, newValue, this.output, this.options);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModuleConfiguration#getOutput() output} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for output
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModuleConfiguration withOutput(String value) {
    if (this.output.equals(value)) return this;
    String newValue = Preconditions.checkNotNull(value, "output");
    return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, this.generator, newValue, this.options);
  }

  /**
   * Copy the current immutable object by replacing the {@link ModuleConfiguration#getOptions() options} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the options map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableModuleConfiguration withOptions(Map<String, ? extends Object> entries) {
    if (this.options == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, this.generator, this.output, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableModuleConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableModuleConfiguration
        && equalTo((ImmutableModuleConfiguration) another);
  }

  private boolean equalTo(ImmutableModuleConfiguration another) {
    return name.equals(another.name)
        && includePaths.equals(another.includePaths)
        && protoFiles.equals(another.protoFiles)
        && generator.equals(another.generator)
        && output.equals(another.output)
        && options.equals(another.options);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code includePaths}, {@code protoFiles}, {@code generator}, {@code output}, {@code options}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + includePaths.hashCode();
    h += (h << 5) + protoFiles.hashCode();
    h += (h << 5) + generator.hashCode();
    h += (h << 5) + output.hashCode();
    h += (h << 5) + options.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ModuleConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModuleConfiguration")
        .omitNullValues()
        .add("name", name)
        .add("includePaths", includePaths)
        .add("protoFiles", protoFiles)
        .add("generator", generator)
        .add("output", output)
        .add("options", options)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ModuleConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ModuleConfiguration instance
   */
  public static ImmutableModuleConfiguration copyOf(ModuleConfiguration instance) {
    if (instance instanceof ImmutableModuleConfiguration) {
      return (ImmutableModuleConfiguration) instance;
    }
    return ImmutableModuleConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableModuleConfiguration ImmutableModuleConfiguration}.
   * @return A new ImmutableModuleConfiguration builder
   */
  public static ImmutableModuleConfiguration.Builder builder() {
    return new ImmutableModuleConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableModuleConfiguration ImmutableModuleConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_GENERATOR = 0x2L;
    private static final long INIT_BIT_OUTPUT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String name;
    private ImmutableList.Builder<Path> includePaths = ImmutableList.builder();
    private ImmutableList.Builder<String> protoFiles = ImmutableList.builder();
    private @Nullable String generator;
    private @Nullable String output;
    private ImmutableMap.Builder<String, Object> options = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModuleConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModuleConfiguration instance) {
      Preconditions.checkNotNull(instance, "instance");
      name(instance.getName());
      addAllIncludePaths(instance.getIncludePaths());
      addAllProtoFiles(instance.getProtoFiles());
      generator(instance.getGenerator());
      output(instance.getOutput());
      putAllOptions(instance.getOptions());
      return this;
    }

    /**
     * Initializes the value for the {@link ModuleConfiguration#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link ModuleConfiguration#getIncludePaths() includePaths} list.
     * @param element A includePaths element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIncludePaths(Path element) {
      this.includePaths.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ModuleConfiguration#getIncludePaths() includePaths} list.
     * @param elements An array of includePaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIncludePaths(Path... elements) {
      this.includePaths.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ModuleConfiguration#getIncludePaths() includePaths} list.
     * @param elements An iterable of includePaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder includePaths(Iterable<? extends Path> elements) {
      this.includePaths = ImmutableList.builder();
      return addAllIncludePaths(elements);
    }

    /**
     * Adds elements to {@link ModuleConfiguration#getIncludePaths() includePaths} list.
     * @param elements An iterable of includePaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllIncludePaths(Iterable<? extends Path> elements) {
      this.includePaths.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ModuleConfiguration#getProtoFiles() protoFiles} list.
     * @param element A protoFiles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProtoFiles(String element) {
      this.protoFiles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ModuleConfiguration#getProtoFiles() protoFiles} list.
     * @param elements An array of protoFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProtoFiles(String... elements) {
      this.protoFiles.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ModuleConfiguration#getProtoFiles() protoFiles} list.
     * @param elements An iterable of protoFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder protoFiles(Iterable<String> elements) {
      this.protoFiles = ImmutableList.builder();
      return addAllProtoFiles(elements);
    }

    /**
     * Adds elements to {@link ModuleConfiguration#getProtoFiles() protoFiles} list.
     * @param elements An iterable of protoFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllProtoFiles(Iterable<String> elements) {
      this.protoFiles.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ModuleConfiguration#getGenerator() generator} attribute.
     * @param generator The value for generator 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder generator(String generator) {
      this.generator = Preconditions.checkNotNull(generator, "generator");
      initBits &= ~INIT_BIT_GENERATOR;
      return this;
    }

    /**
     * Initializes the value for the {@link ModuleConfiguration#getOutput() output} attribute.
     * @param output The value for output 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder output(String output) {
      this.output = Preconditions.checkNotNull(output, "output");
      initBits &= ~INIT_BIT_OUTPUT;
      return this;
    }

    /**
     * Put one entry to the {@link ModuleConfiguration#getOptions() options} map.
     * @param key The key in the options map
     * @param value The associated value in the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOptions(String key, Object value) {
      this.options.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ModuleConfiguration#getOptions() options} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOptions(Map.Entry<String, ? extends Object> entry) {
      this.options.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ModuleConfiguration#getOptions() options} map. Nulls are not permitted
     * @param options The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder options(Map<String, ? extends Object> options) {
      this.options = ImmutableMap.builder();
      return putAllOptions(options);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ModuleConfiguration#getOptions() options} map. Nulls are not permitted
     * @param options The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllOptions(Map<String, ? extends Object> options) {
      this.options.putAll(options);
      return this;
    }

    /**
     * Builds a new {@link ImmutableModuleConfiguration ImmutableModuleConfiguration}.
     * @return An immutable instance of ModuleConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableModuleConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableModuleConfiguration(name, includePaths.build(), protoFiles.build(), generator, output, options.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_GENERATOR) != 0) attributes.add("generator");
      if ((initBits & INIT_BIT_OUTPUT) != 0) attributes.add("output");
      return "Cannot build ModuleConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
