/*
 * Decompiled with CFR 0.152.
 */
package io.operon.camel.language;

import io.operon.camel.OperonProcessor;
import io.operon.runner.model.OperonConfigs;
import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.support.ExpressionAdapter;

public class OperonExpression
extends ExpressionAdapter {
    private String expression;
    private String inputMimeType;
    private String outputMimeType;
    private OperonProcessor processor;
    private Expression innerExpression;
    private OperonConfigs configs;

    public OperonExpression(String expression) {
        this.expression = expression;
        this.processor = new OperonProcessor();
        this.processor.setOperonScript(expression);
        this.configs = new OperonConfigs();
        this.configs.setOutputResult(false);
        try {
            this.processor.init();
        }
        catch (Exception e) {
            throw new RuntimeExpressionException("Unable to initialize Operon processor : ", (Throwable)e);
        }
    }

    public OperonExpression(Expression expression) {
        this.innerExpression = expression;
        this.processor = new OperonProcessor();
        try {
            this.processor.init();
        }
        catch (Exception e) {
            throw new RuntimeExpressionException("Unable to initialize Operon processor : ", (Throwable)e);
        }
    }

    public String toString() {
        return "operon: " + this.expression;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        OperonConfigs overrideConfigs = (OperonConfigs)exchange.getIn().getHeader("operonConfigs", OperonConfigs.class);
        if (overrideConfigs != null) {
            this.configs = overrideConfigs;
        }
        if (this.inputMimeType != null) {
            exchange.setProperty("inputMimeType", (Object)this.inputMimeType);
        } else {
            String inMimeType = (String)exchange.getIn().getHeader("inputMimeType");
            if (inMimeType != null) {
                this.inputMimeType = inMimeType;
            }
        }
        if (this.outputMimeType != null) {
            exchange.setProperty("outputMimeType", (Object)this.outputMimeType);
        } else {
            String outMimeType = (String)exchange.getIn().getHeader("outputMimeType");
            if (outMimeType != null) {
                this.outputMimeType = outMimeType;
            }
        }
        try {
            String modulePathsStr;
            if (this.innerExpression != null) {
                String script;
                this.expression = script = (String)this.innerExpression.evaluate(exchange, String.class);
                this.processor.setOperonScript(script);
            }
            if ((modulePathsStr = (String)exchange.getIn().getHeader("operonModules", String.class)) != null) {
                ArrayList<String> modulePaths = new ArrayList<String>();
                String[] paths = modulePathsStr.split(",");
                for (int i = 0; i < paths.length; ++i) {
                    String p = paths[i].trim();
                    modulePaths.add(p);
                }
                this.processor.setModulePaths(modulePaths);
            }
            Object value = this.processor.processMapping(exchange, this.configs, this.inputMimeType, this.outputMimeType);
            return (T)exchange.getContext().getTypeConverter().convertTo(type, value);
        }
        catch (Exception e) {
            throw new RuntimeExpressionException("Unable to evaluate Operon expression : " + this.expression, (Throwable)e);
        }
    }

    public String getInputMimeType() {
        return this.inputMimeType;
    }

    public void setInputMimeType(String inputMimeType) {
        this.inputMimeType = inputMimeType;
    }

    public String getOutputMimeType() {
        return this.outputMimeType;
    }

    public void setOutputMimeType(String outputMimeType) {
        this.outputMimeType = outputMimeType;
    }

    public Expression getInnerExpression() {
        return this.innerExpression;
    }

    public void setInnerExpression(Expression innerExpression) {
        this.innerExpression = innerExpression;
    }
}

