/*
 * Decompiled with CFR 0.152.
 */
package io.operon.camel;

import com.google.gson.Gson;
import io.operon.camel.model.exception.UnsupportedMimeTypeException;
import io.operon.camel.util.QueryLoadUtil;
import io.operon.runner.Context;
import io.operon.runner.EmptyContext;
import io.operon.runner.OperonRunner;
import io.operon.runner.model.ModuleDefinition;
import io.operon.runner.model.OperonConfigs;
import io.operon.runner.node.type.ArrayType;
import io.operon.runner.node.type.ObjectType;
import io.operon.runner.node.type.OperonValue;
import io.operon.runner.node.type.PairType;
import io.operon.runner.node.type.RawValue;
import io.operon.runner.statement.DefaultStatement;
import io.operon.runner.statement.Statement;
import io.operon.runner.util.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class OperonProcessor
implements Processor {
    private List<String> modulePaths;
    private Map<String, String> namedImports = new HashMap<String, String>();
    private List<String> supportedMimeTypes = new ArrayList<String>(Arrays.asList("application/json", "application/java", "application/java-list", "application/octet-stream"));
    private String inputMimeType;
    private String outputMimeType;
    private String operonFile;
    private String operonScript;
    private List<ModuleDefinition> modules;
    private boolean debug = false;

    public void process(Exchange exchange) throws Exception {
        Object mappedBody = this.processMapping(exchange);
        exchange.getIn().setBody(mappedBody);
    }

    public void init() throws Exception {
        if (this.modules == null) {
            this.modules = new ArrayList<ModuleDefinition>();
        }
        if (this.modulePaths != null) {
            for (int i = 0; i < this.modulePaths.size(); ++i) {
                String modulePath = this.modulePaths.get(i);
                String[] modulePathParts = modulePath.split(":");
                String moduleBody = QueryLoadUtil.loadModuleFile(modulePathParts[1]);
                ModuleDefinition md = new ModuleDefinition();
                md.setBody(moduleBody);
                md.setNamespace(modulePathParts[0]);
                md.setFilePath(modulePathParts[1]);
                this.modules.add(md);
                if (!this.isDebug()) continue;
                System.out.println("=== Added module ===");
            }
        }
    }

    public List<String> getModulesPaths() {
        return this.modulePaths;
    }

    public void setModulePaths(List<String> mp) {
        this.modulePaths = mp;
    }

    public String getInputMimeType() {
        return this.inputMimeType;
    }

    public void setInputMimeType(String inputMimeType) {
        this.inputMimeType = inputMimeType;
    }

    public String getOutputMimeType() {
        return this.outputMimeType;
    }

    public void setOutputMimeType(String outputMimeType) {
        this.outputMimeType = outputMimeType;
    }

    public String getOperonFile() {
        return this.operonFile;
    }

    public void setOperonFile(String operonFile) {
        this.operonFile = operonFile;
    }

    public String getOperonScript() {
        return this.operonScript;
    }

    public void setOperonScript(String operonScript) {
        this.operonScript = operonScript;
    }

    public Object processMapping(Exchange exchange) throws Exception {
        return this.processMapping(exchange, null, null, null);
    }

    public Object processMapping(Exchange exchange, OperonConfigs operonConfigs, String _inputMimeType, String _outputMimeType) throws Exception {
        Object initialValueData;
        String queryFile;
        String query;
        OperonConfigs configs = null;
        configs = operonConfigs == null ? new OperonConfigs() : operonConfigs;
        if (_inputMimeType == null || "".equalsIgnoreCase(_inputMimeType.trim())) {
            String overriddenInputMimeType = (String)exchange.getIn().getHeader("inputMimeType");
            if (overriddenInputMimeType == null && (overriddenInputMimeType = (String)exchange.getIn().getHeader("content_type")) == "application/java-list") {
                overriddenInputMimeType = "application/java";
            }
            if (overriddenInputMimeType == null) {
                overriddenInputMimeType = "UNKNOWN_MIME_TYPE";
            }
            _inputMimeType = overriddenInputMimeType;
        }
        if (!this.supportedMimeTypes.contains(_inputMimeType)) {
            if (this.isDebug()) {
                System.out.println("inputMimeType :: not found :: set application/json");
            }
            _inputMimeType = "application/json";
        }
        if (_outputMimeType == null || "".equalsIgnoreCase(_outputMimeType.trim())) {
            String overriddenOutputMimeType = (String)exchange.getIn().getHeader("outputMimeType");
            if (overriddenOutputMimeType == null) {
                overriddenOutputMimeType = (String)exchange.getIn().getHeader("content_type");
            }
            if (overriddenOutputMimeType == null) {
                overriddenOutputMimeType = "UNKNOWN_MIME_TYPE";
            }
            _outputMimeType = overriddenOutputMimeType;
        }
        if (!this.supportedMimeTypes.contains(_outputMimeType)) {
            if (this.isDebug()) {
                System.out.println("outputMimeType :: not found :: set application/json");
            }
            _outputMimeType = "application/json";
        }
        if ((query = this.getOperonScript()) == null) {
            query = (String)exchange.getIn().getHeader("operonScript");
        }
        if (query == null && (queryFile = (String)exchange.getIn().getHeader("operonScriptPath")) != null && queryFile.length() > 0) {
            query = QueryLoadUtil.loadQueryFile(queryFile);
        }
        boolean queryInBody = false;
        if (query == null) {
            query = (String)exchange.getIn().getBody(String.class);
            queryInBody = true;
        }
        if ((initialValueData = exchange.getIn().getHeader("initialValue")) == null && !queryInBody) {
            initialValueData = exchange.getIn().getBody();
        }
        OperonValue initialValue = null;
        OperonValue resultValue = null;
        Map valueBindings = (Map)exchange.getIn().getHeader("operonValueBindings", Map.class);
        if (valueBindings != null) {
            HashMap valueBindingsHM = (HashMap)valueBindings;
            for (Map.Entry entry : valueBindingsHM.entrySet()) {
                OperonValue operonValue = JsonUtil.operonValueFromString((String)((String)entry.getValue()));
                configs.setNamedValue("$" + (String)entry.getKey(), operonValue);
            }
        }
        if (initialValueData != null) {
            if (_inputMimeType.equalsIgnoreCase("application/json")) {
                String initialValueStr = (String)initialValueData;
                if (initialValueStr.isEmpty()) {
                    initialValueStr = "empty";
                }
                initialValue = JsonUtil.operonValueFromString((String)initialValueStr);
            } else if (_inputMimeType.equalsIgnoreCase("application/java")) {
                Gson gson = new Gson();
                String jsonString = gson.toJson(initialValueData);
                if (jsonString.isEmpty()) {
                    jsonString = "empty";
                }
                initialValue = JsonUtil.operonValueFromString((String)jsonString);
            } else if (_inputMimeType.equalsIgnoreCase("application/octet-stream")) {
                byte[] initialValueBytes = (byte[])initialValueData;
                if (initialValueBytes.length == 0) {
                    initialValue = JsonUtil.operonValueFromString((String)"empty");
                } else {
                    EmptyContext ctx = new EmptyContext();
                    DefaultStatement stmt = new DefaultStatement((Context)ctx);
                    RawValue raw = new RawValue((Statement)stmt);
                    raw.setValue(initialValueBytes);
                    initialValue = raw;
                }
            }
            resultValue = this.modules == null || this.modules.size() == 0 ? OperonRunner.doQueryWithInitialValue((String)query, (OperonValue)initialValue, (OperonConfigs)configs) : OperonRunner.doQueryWithInitialValueAndModules((String)query, (OperonValue)initialValue, (OperonConfigs)configs, this.modules);
        } else {
            resultValue = OperonRunner.doQuery((String)query, (OperonConfigs)configs);
        }
        if (this.isDebug()) {
            System.out.println("inputMimeType :: " + _inputMimeType);
            System.out.println("outputMimeType :: " + _outputMimeType);
        }
        if (_outputMimeType.equalsIgnoreCase("application/json")) {
            return resultValue.toString();
        }
        if (_outputMimeType.equalsIgnoreCase("application/java")) {
            return resultValue;
        }
        if (_outputMimeType.equalsIgnoreCase("application/java-list")) {
            if ((resultValue = resultValue.evaluate()) instanceof ArrayType) {
                ArrayType array = (ArrayType)resultValue;
                return array.getValues();
            }
            if (resultValue instanceof ObjectType) {
                ObjectType object = (ObjectType)resultValue;
                List pairs = object.getPairs();
                ArrayList<ObjectType> result = new ArrayList<ObjectType>();
                for (PairType pair : pairs) {
                    ObjectType resultPairObj = new ObjectType(pair.getStatement());
                    resultPairObj.addPair(pair);
                    result.add(resultPairObj);
                }
                return result;
            }
            ArrayList<OperonValue> resultValueAsList = new ArrayList<OperonValue>();
            resultValueAsList.add(resultValue);
            return resultValueAsList;
        }
        if (_outputMimeType.equalsIgnoreCase("application/octet-stream")) {
            RawValue raw = (RawValue)resultValue;
            return raw.getBytes();
        }
        throw new UnsupportedMimeTypeException(_outputMimeType);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

