/*
 * Decompiled with CFR 0.152.
 */
package io.operon.camel;

import io.operon.camel.CamelOperonEndpoint;
import io.operon.camel.OperonProcessor;
import io.operon.camel.util.QueryLoadUtil;
import io.operon.runner.model.OperonConfigs;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelOperonProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CamelOperonProducer.class);
    private final String HEADER_OPERON_MODULES = "operonModules";
    private CamelOperonEndpoint endpoint;
    private String queryFile = null;
    private String query = null;
    private OperonConfigs configs = null;
    private boolean debug = false;
    private OperonProcessor processor;

    public CamelOperonProducer(CamelOperonEndpoint endpoint) throws IOException, URISyntaxException {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configs = new OperonConfigs();
        this.queryFile = endpoint.getQueryFile();
        this.debug = endpoint.isDebug();
        this.processor = new OperonProcessor();
        this.processor.setDebug(this.debug);
        if (this.queryFile != null) {
            if (this.debug) {
                LOG.info("queryFile=" + this.queryFile);
            }
            this.query = QueryLoadUtil.loadQueryFile(this.queryFile);
        }
        this.configs.setOutputResult(endpoint.isOutputResult());
        this.configs.setPrettyPrint(endpoint.isPrettyPrint());
        if (endpoint.getTimezone() != null && !endpoint.getTimezone().isEmpty()) {
            this.configs.setTimezone(endpoint.getTimezone());
        }
        this.configs.setPrintDuration(endpoint.isPrintDuration());
    }

    public void process(Exchange exchange) throws Exception {
        String inputMimeType = null;
        String outputMimeType = null;
        this.processor.setOperonScript(this.query);
        String modulePathsStr = (String)exchange.getIn().getHeader("operonModules", String.class);
        if (modulePathsStr != null) {
            ArrayList<String> modulePaths = new ArrayList<String>();
            String[] paths = modulePathsStr.split(",");
            for (int i = 0; i < paths.length; ++i) {
                String p = paths[i].trim();
                modulePaths.add(p);
            }
            this.processor.setModulePaths(modulePaths);
            this.processor.init();
        }
        Object result = this.processor.processMapping(exchange, this.configs, inputMimeType, outputMimeType);
        exchange.getIn().setBody(result);
    }
}

