/*
 * Decompiled with CFR 0.152.
 */
package io.operon.camel;

import io.operon.camel.CamelOperonComponent;
import io.operon.camel.CamelOperonProducer;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="1.0-SNAPSHOT", scheme="operon", title="camel-operon-component", syntax="operon:name", category={Category.JAVA}, producerOnly=true)
public class CamelOperonEndpoint
extends DefaultEndpoint {
    @UriPath(defaultValue="", description="Identifies the operon, used in logging.")
    @Metadata(required=false)
    private String name;
    @UriParam(defaultValue="", description="file://path/to/queryfile.op or classpath://classpath/to/queryFile.op. Omitting file:// or classpath:// assumes that queryFile is in the classpath.")
    private String queryFile;
    @UriParam(description="Output the result in to the System.out")
    private boolean outputResult = false;
    @UriParam(description="Formats the result")
    private boolean prettyPrint = false;
    @UriParam(defaultValue="", description="Timezone for date-functions")
    private String timezone;
    @UriParam(description="Prints how long the query took to execute")
    private boolean printDuration = false;
    @UriParam(description="Prints some debug-information during the execution")
    private boolean debug = false;
    @UriParam(description="Set to index the root-object")
    private boolean indexRoot = false;
    @UriParam(description="Throws Java-exception when Operon Error-value was returned")
    private boolean throwOnError = false;

    public CamelOperonEndpoint() {
    }

    public CamelOperonEndpoint(String uri, CamelOperonComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new CamelOperonProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new Exception("camel-operon does not support consumer");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setQueryFile(String queryFile) {
        this.queryFile = queryFile;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public void setOutputResult(boolean or) {
        this.outputResult = or;
    }

    public boolean isOutputResult() {
        return this.outputResult;
    }

    public void setPrettyPrint(boolean pp) {
        this.prettyPrint = pp;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setTimezone(String tz) {
        this.timezone = tz;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setPrintDuration(boolean pd) {
        this.printDuration = pd;
    }

    public boolean isPrintDuration() {
        return this.printDuration;
    }

    public void setIndexRoot(boolean ir) {
        this.indexRoot = ir;
    }

    public boolean isIndexRoot() {
        return this.indexRoot;
    }

    public void setThrowOnError(boolean t) {
        this.throwOnError = t;
    }

    public boolean isThrowOnError() {
        return this.throwOnError;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "CamelOperonConsumer");
    }
}

