/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logging.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.logging.data.AutoValue_AnyValue_AnyValueArray;
import io.opentelemetry.sdk.logging.data.AutoValue_AnyValue_AnyValueBool;
import io.opentelemetry.sdk.logging.data.AutoValue_AnyValue_AnyValueDouble;
import io.opentelemetry.sdk.logging.data.AutoValue_AnyValue_AnyValueKvlist;
import io.opentelemetry.sdk.logging.data.AutoValue_AnyValue_AnyValueLong;
import io.opentelemetry.sdk.logging.data.AutoValue_AnyValue_AnyValueString;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AnyValue {
    public static AnyValue stringAnyValue(String stringValue) {
        return AnyValueString.create(stringValue);
    }

    public String getStringValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public static AnyValue longAnyValue(long longValue) {
        return AnyValueLong.create(longValue);
    }

    public long getLongValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public static AnyValue boolAnyValue(boolean boolValue) {
        return AnyValueBool.create(boolValue);
    }

    public boolean getBoolValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public static AnyValue doubleAnyValue(double doubleValue) {
        return AnyValueDouble.create(doubleValue);
    }

    public double getDoubleValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public static AnyValue arrayAnyValue(List<AnyValue> values) {
        return AnyValueArray.create(values);
    }

    public List<AnyValue> getArrayValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public static AnyValue kvlistAnyValue(Map<String, AnyValue> values) {
        return AnyValueKvlist.create(values);
    }

    public Map<String, AnyValue> getKvlistValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public abstract Type getType();

    @Immutable
    @AutoValue
    static abstract class AnyValueKvlist
    extends AnyValue {
        AnyValueKvlist() {
        }

        static AnyValue create(Map<String, AnyValue> kvlistValue) {
            return new AutoValue_AnyValue_AnyValueKvlist(kvlistValue);
        }

        @Override
        public final Type getType() {
            return Type.KVLIST;
        }

        @Override
        public abstract Map<String, AnyValue> getKvlistValue();
    }

    @Immutable
    @AutoValue
    static abstract class AnyValueArray
    extends AnyValue {
        AnyValueArray() {
        }

        static AnyValue create(List<AnyValue> arrayValue) {
            return new AutoValue_AnyValue_AnyValueArray(arrayValue);
        }

        @Override
        public final Type getType() {
            return Type.ARRAY;
        }

        @Override
        public abstract List<AnyValue> getArrayValue();
    }

    @Immutable
    @AutoValue
    static abstract class AnyValueDouble
    extends AnyValue {
        AnyValueDouble() {
        }

        static AnyValue create(double doubleValue) {
            return new AutoValue_AnyValue_AnyValueDouble(doubleValue);
        }

        @Override
        public final Type getType() {
            return Type.DOUBLE;
        }

        @Override
        public abstract double getDoubleValue();
    }

    @Immutable
    @AutoValue
    static abstract class AnyValueBool
    extends AnyValue {
        AnyValueBool() {
        }

        static AnyValue create(boolean boolValue) {
            return new AutoValue_AnyValue_AnyValueBool(boolValue);
        }

        @Override
        public final Type getType() {
            return Type.BOOL;
        }

        @Override
        public abstract boolean getBoolValue();
    }

    @Immutable
    @AutoValue
    static abstract class AnyValueLong
    extends AnyValue {
        AnyValueLong() {
        }

        static AnyValue create(long longValue) {
            return new AutoValue_AnyValue_AnyValueLong(longValue);
        }

        @Override
        public final Type getType() {
            return Type.INT64;
        }

        @Override
        public abstract long getLongValue();
    }

    @Immutable
    @AutoValue
    static abstract class AnyValueString
    extends AnyValue {
        AnyValueString() {
        }

        static AnyValue create(String stringValue) {
            return new AutoValue_AnyValue_AnyValueString(stringValue);
        }

        @Override
        public final Type getType() {
            return Type.STRING;
        }

        @Override
        @Nullable
        public abstract String getStringValue();
    }

    public static enum Type {
        STRING,
        BOOL,
        INT64,
        DOUBLE,
        ARRAY,
        KVLIST;

    }
}

