/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logging;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logging.LogProcessor;
import io.opentelemetry.sdk.logging.LogSink;
import io.opentelemetry.sdk.logging.LogSinkSdkProviderBuilder;
import io.opentelemetry.sdk.logging.data.LogRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class LogSinkSdkProvider {
    private final LogSink logSink = new SdkLogSink();
    private final List<LogProcessor> processors = new ArrayList<LogProcessor>();

    static LogSinkSdkProviderBuilder builder() {
        return new LogSinkSdkProviderBuilder();
    }

    LogSinkSdkProvider() {
    }

    public LogSink get(String instrumentationName, String instrumentationVersion) {
        return this.logSink;
    }

    public void addLogProcessor(LogProcessor processor) {
        this.processors.add(Objects.requireNonNull(processor, "Processor can not be null"));
    }

    public CompletableResultCode forceFlush() {
        ArrayList<CompletableResultCode> processorResults = new ArrayList<CompletableResultCode>(this.processors.size());
        for (LogProcessor processor : this.processors) {
            processorResults.add(processor.forceFlush());
        }
        return CompletableResultCode.ofAll(processorResults);
    }

    public CompletableResultCode shutdown() {
        ArrayList<CompletableResultCode> processorResults = new ArrayList<CompletableResultCode>(this.processors.size());
        for (LogProcessor processor : this.processors) {
            processorResults.add(processor.shutdown());
        }
        return CompletableResultCode.ofAll(processorResults);
    }

    private class SdkLogSink
    implements LogSink {
        private SdkLogSink() {
        }

        @Override
        public void offer(LogRecord record) {
            for (LogProcessor processor : LogSinkSdkProvider.this.processors) {
                processor.addLogRecord(record);
            }
        }
    }
}

