/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.aws.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.extension.aws.resource.DockerHelper;
import io.opentelemetry.sdk.extension.aws.resource.JdkHttpClient;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EksResource {
    private static final Logger logger = Logger.getLogger(EksResource.class.getName());
    private static final Resource INSTANCE = EksResource.buildResource();
    static final String K8S_SVC_URL = "https://kubernetes.default.svc";
    static final String AUTH_CONFIGMAP_PATH = "/api/v1/namespaces/kube-system/configmaps/aws-auth";
    static final String CW_CONFIGMAP_PATH = "/api/v1/namespaces/amazon-cloudwatch/configmaps/cluster-info";
    private static final String K8S_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String K8S_CERT_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";

    public static Resource get() {
        return INSTANCE;
    }

    private static Resource buildResource() {
        return EksResource.buildResource(new JdkHttpClient(), new DockerHelper(), K8S_TOKEN_PATH, K8S_CERT_PATH);
    }

    static Resource buildResource(JdkHttpClient jdkHttpClient, DockerHelper dockerHelper, String k8sTokenPath, String k8sKeystorePath) {
        String containerId;
        if (!EksResource.isEks(k8sTokenPath, k8sKeystorePath, jdkHttpClient)) {
            return Resource.empty();
        }
        AttributesBuilder attrBuilders = Attributes.builder();
        String clusterName = EksResource.getClusterName(jdkHttpClient);
        if (clusterName != null && !clusterName.isEmpty()) {
            attrBuilders.put(ResourceAttributes.K8S_CLUSTER_NAME, (Object)clusterName);
        }
        if ((containerId = dockerHelper.getContainerId()) != null && !containerId.isEmpty()) {
            attrBuilders.put(ResourceAttributes.CONTAINER_ID, (Object)containerId);
        }
        return Resource.create((Attributes)attrBuilders.build());
    }

    private static boolean isEks(String k8sTokenPath, String k8sKeystorePath, JdkHttpClient jdkHttpClient) {
        if (!EksResource.isK8s(k8sTokenPath, k8sKeystorePath)) {
            logger.log(Level.FINE, "Not running on k8s.");
            return false;
        }
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("Authorization", EksResource.getK8sCredHeader());
        String awsAuth = jdkHttpClient.fetchString("GET", "https://kubernetes.default.svc/api/v1/namespaces/kube-system/configmaps/aws-auth", requestProperties, K8S_CERT_PATH);
        return awsAuth != null && !awsAuth.isEmpty();
    }

    private static boolean isK8s(String k8sTokenPath, String k8sKeystorePath) {
        File k8sTokeyFile = new File(k8sTokenPath);
        File k8sKeystoreFile = new File(k8sKeystorePath);
        return k8sTokeyFile.exists() && k8sKeystoreFile.exists();
    }

    private static String getClusterName(JdkHttpClient jdkHttpClient) {
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("Authorization", EksResource.getK8sCredHeader());
        String json = jdkHttpClient.fetchString("GET", "https://kubernetes.default.svc/api/v1/namespaces/amazon-cloudwatch/configmaps/cluster-info", requestProperties, K8S_CERT_PATH);
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(json).at("/data/cluster.name").asText();
        }
        catch (JsonProcessingException e) {
            logger.log(Level.WARNING, "Can't get cluster name on EKS.", e);
            return "";
        }
    }

    private static String getK8sCredHeader() {
        try {
            String content = new String(Files.readAllBytes(Paths.get(K8S_TOKEN_PATH, new String[0])), StandardCharsets.UTF_8);
            return "Bearer " + content;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to load K8s client token.", e);
            return "";
        }
    }

    private EksResource() {
    }
}

