/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.aws.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.extension.aws.resource.AwsResourceConstants;
import io.opentelemetry.sdk.extension.aws.resource.JdkHttpClient;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Ec2Resource {
    private static final Logger logger = Logger.getLogger(Ec2Resource.class.getName());
    private static final Resource INSTANCE = Ec2Resource.buildResource();
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final String DEFAULT_IMDS_ENDPOINT = "169.254.169.254";

    public static Resource get() {
        return INSTANCE;
    }

    private static Resource buildResource() {
        return Ec2Resource.buildResource(System.getProperty("otel.aws.imds.endpointOverride", DEFAULT_IMDS_ENDPOINT));
    }

    static Resource buildResource(String endpoint) {
        URL tokenUrl;
        URL hostnameUrl;
        URL identityDocumentUrl;
        String urlBase = "http://" + endpoint;
        try {
            identityDocumentUrl = new URL(urlBase + "/latest/dynamic/instance-identity/document");
            hostnameUrl = new URL(urlBase + "/latest/meta-data/hostname");
            tokenUrl = new URL(urlBase + "/latest/api/token");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Illegal endpoint: " + endpoint, e);
        }
        String token = Ec2Resource.fetchToken(tokenUrl);
        String identity = Ec2Resource.fetchIdentity(identityDocumentUrl, token);
        if (identity.isEmpty()) {
            return Resource.empty();
        }
        String hostname = Ec2Resource.fetchHostname(hostnameUrl, token);
        AttributesBuilder attrBuilders = Attributes.builder();
        attrBuilders.put(ResourceAttributes.CLOUD_PROVIDER, (Object)AwsResourceConstants.cloudProvider());
        try (JsonParser parser = JSON_FACTORY.createParser(identity);){
            parser.nextToken();
            if (!parser.isExpectedStartObjectToken()) {
                throw new IOException("Invalid JSON:" + identity);
            }
            block25: while (parser.nextToken() != JsonToken.END_OBJECT) {
                String value = parser.nextTextValue();
                switch (parser.getCurrentName()) {
                    case "instanceId": {
                        attrBuilders.put(ResourceAttributes.HOST_ID, (Object)value);
                        continue block25;
                    }
                    case "availabilityZone": {
                        attrBuilders.put(ResourceAttributes.CLOUD_ZONE, (Object)value);
                        continue block25;
                    }
                    case "instanceType": {
                        attrBuilders.put(ResourceAttributes.HOST_TYPE, (Object)value);
                        continue block25;
                    }
                    case "imageId": {
                        attrBuilders.put(ResourceAttributes.HOST_IMAGE_ID, (Object)value);
                        continue block25;
                    }
                    case "accountId": {
                        attrBuilders.put(ResourceAttributes.CLOUD_ACCOUNT_ID, (Object)value);
                        continue block25;
                    }
                    case "region": {
                        attrBuilders.put(ResourceAttributes.CLOUD_REGION, (Object)value);
                        continue block25;
                    }
                }
                parser.skipChildren();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not parse identity document, resource not filled.", e);
            return Resource.empty();
        }
        attrBuilders.put(ResourceAttributes.HOST_NAME, (Object)hostname);
        return Resource.create((Attributes)attrBuilders.build());
    }

    private static String fetchToken(URL tokenUrl) {
        return Ec2Resource.fetchString("PUT", tokenUrl, "", true);
    }

    private static String fetchIdentity(URL identityDocumentUrl, String token) {
        return Ec2Resource.fetchString("GET", identityDocumentUrl, token, false);
    }

    private static String fetchHostname(URL hostnameUrl, String token) {
        return Ec2Resource.fetchString("GET", hostnameUrl, token, false);
    }

    private static String fetchString(String httpMethod, URL url, String token, boolean includeTtl) {
        JdkHttpClient client = new JdkHttpClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (includeTtl) {
            headers.put("X-aws-ec2-metadata-token-ttl-seconds", "60");
        }
        if (!token.isEmpty()) {
            headers.put("X-aws-ec2-metadata-token", token);
        }
        return client.fetchString(httpMethod, url.toString(), headers, null);
    }

    private Ec2Resource() {
    }
}

