/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.play.v2_6;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRouteSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import play.api.libs.typedmap.TypedKey;
import play.api.mvc.Request;
import play.api.routing.HandlerDef;
import play.routing.Router;
import scala.Option;

public final class Play26Singletons {
    private static final String SPAN_NAME = "play.request";
    private static final Instrumenter<Void, Void> INSTRUMENTER = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)"io.opentelemetry.play-mvc-2.6", s -> "play.request").buildInstrumenter();
    @Nullable
    private static final Method typedKeyGetUnderlying;

    public static Instrumenter<Void, Void> instrumenter() {
        return INSTRUMENTER;
    }

    public static void updateSpan(Context context, Request<?> request) {
        String route = Play26Singletons.getRoute(request);
        if (route == null) {
            return;
        }
        Span.fromContext((Context)context).updateName(route);
        HttpServerRoute.update((Context)context, (HttpServerRouteSource)HttpServerRouteSource.CONTROLLER, (String)route);
    }

    private static String getRoute(Request<?> request) {
        if (request != null) {
            Option defOption = null;
            if (typedKeyGetUnderlying != null) {
                try {
                    TypedKey handlerDef = (TypedKey)typedKeyGetUnderlying.invoke((Object)Router.Attrs.HANDLER_DEF, new Object[0]);
                    defOption = request.attrs().get(handlerDef);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (defOption != null && !defOption.isEmpty()) {
                return ((HandlerDef)defOption.get()).path();
            }
        }
        return null;
    }

    private Play26Singletons() {
    }

    static {
        Method typedKeyGetUnderlyingCheck = null;
        try {
            typedKeyGetUnderlyingCheck = play.libs.typedmap.TypedKey.class.getMethod("asScala", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (typedKeyGetUnderlyingCheck == null) {
            try {
                typedKeyGetUnderlyingCheck = play.libs.typedmap.TypedKey.class.getMethod("underlying", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        typedKeyGetUnderlying = typedKeyGetUnderlyingCheck;
    }
}

