/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.play.v2_6;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.play.v2_6.Play26Singletons;
import io.opentelemetry.javaagent.instrumentation.play.v2_6.ResponseFutureWrapper;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import play.api.mvc.Action;
import play.api.mvc.Request;
import play.api.mvc.Result;
import scala.concurrent.Future;

public class ActionInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"play.api.mvc.Action"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"play.api.mvc.Action"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"apply").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"play.api.mvc.Request"))).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)ElementMatchers.named((String)"scala.concurrent.Future"))), this.getClass().getName() + "$ApplyAdvice");
    }

    public static class ApplyAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) Request<?> req, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!Play26Singletons.instrumenter().shouldStart(parentContext, null)) {
                return;
            }
            context = Play26Singletons.instrumenter().start(parentContext, null);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopTraceOnResponse(@Advice.This Object thisAction, @Advice.Thrown Throwable throwable, @Advice.Argument(value=0) Request<?> req, @Advice.Return(readOnly=false) Future<Result> responseFuture, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            scope.close();
            Play26Singletons.updateSpan(context, req);
            if (throwable == null) {
                responseFuture = ResponseFutureWrapper.wrap(responseFuture, context, ((Action)thisAction).executionContext());
            } else {
                Play26Singletons.instrumenter().end(context, null, null, throwable);
            }
        }
    }
}

