/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.internal.InternalNetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import javax.annotation.Nullable;

public final class HttpClientAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpClientAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private final InternalNetClientAttributesExtractor<REQUEST, RESPONSE> internalNetExtractor;

    @Deprecated
    public static <REQUEST, RESPONSE> HttpClientAttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return HttpClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> HttpClientAttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return HttpClientAttributesExtractor.builder(httpAttributesGetter, netAttributesGetter).build();
    }

    @Deprecated
    public static <REQUEST, RESPONSE> HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return HttpClientAttributesExtractor.builder(httpAttributesGetter, new NoopNetClientAttributesGetter());
    }

    public static <REQUEST, RESPONSE> HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return new HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, netAttributesGetter);
    }

    HttpClientAttributesExtractor(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders) {
        super(httpAttributesGetter, capturedRequestHeaders, capturedResponseHeaders);
        this.internalNetExtractor = new InternalNetClientAttributesExtractor<Object, RESPONSE>(netAttributesGetter, this::shouldCapturePeerPort, new HttpCommonAttributesExtractor.HttpNetNamePortGetter<REQUEST>(httpAttributesGetter));
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_URL, (Object)HttpClientAttributesExtractor.stripSensitiveData(((HttpClientAttributesGetter)this.getter).url(request)));
        this.internalNetExtractor.onStart(attributes, request);
    }

    private boolean shouldCapturePeerPort(int port, REQUEST request) {
        String url = ((HttpClientAttributesGetter)this.getter).url(request);
        if (url == null) {
            return true;
        }
        return (!url.startsWith("http://") || port != 80) && (!url.startsWith("https://") || port != 443);
    }

    @Nullable
    private static String stripSensitiveData(@Nullable String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        int schemeEndIndex = url.indexOf(58);
        if (schemeEndIndex == -1) {
            return url;
        }
        int len = url.length();
        if (len <= schemeEndIndex + 2 || url.charAt(schemeEndIndex + 1) != '/' || url.charAt(schemeEndIndex + 2) != '/') {
            return url;
        }
        int atIndex = -1;
        for (int index = schemeEndIndex + 3; index < len; ++index) {
            char c = url.charAt(index);
            if (c == '@') {
                atIndex = index;
            }
            if (c == '/' || c == '?' || c == '#') break;
        }
        if (atIndex == -1 || atIndex == len - 1) {
            return url;
        }
        return url.substring(0, schemeEndIndex + 3) + url.substring(atIndex + 1);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_FLAVOR, (Object)((HttpClientAttributesGetter)this.getter).flavor(request, response));
        this.internalNetExtractor.onEnd(attributes, request, response);
    }

    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_CLIENT;
    }

    private static final class NoopNetClientAttributesGetter<REQUEST, RESPONSE>
    implements NetClientAttributesGetter<REQUEST, RESPONSE> {
        private NoopNetClientAttributesGetter() {
        }

        @Override
        @Nullable
        public String transport(REQUEST request, @Nullable RESPONSE response) {
            return null;
        }

        @Override
        @Nullable
        public String peerName(REQUEST request) {
            return null;
        }

        @Override
        @Nullable
        public Integer peerPort(REQUEST request) {
            return null;
        }
    }
}

