/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.messaging;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class MessagingAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    static final String TEMP_DESTINATION_NAME = "(temporary)";
    private final MessagingAttributesGetter<REQUEST, RESPONSE> getter;
    private final MessageOperation operation;

    public static <REQUEST, RESPONSE> MessagingAttributesExtractor<REQUEST, RESPONSE> create(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return new MessagingAttributesExtractor<REQUEST, RESPONSE>(getter, operation);
    }

    private MessagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        this.getter = getter;
        this.operation = operation;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_SYSTEM, (Object)this.getter.system(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_DESTINATION_KIND, (Object)this.getter.destinationKind(request));
        boolean isTemporaryDestination = this.getter.temporaryDestination(request);
        if (isTemporaryDestination) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_TEMP_DESTINATION, (Object)true);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_DESTINATION, (Object)TEMP_DESTINATION_NAME);
        } else {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_DESTINATION, (Object)this.getter.destination(request));
        }
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_PROTOCOL, (Object)this.getter.protocol(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_PROTOCOL_VERSION, (Object)this.getter.protocolVersion(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_URL, (Object)this.getter.url(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_CONVERSATION_ID, (Object)this.getter.conversationId(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES, (Object)this.getter.messagePayloadSize(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES, (Object)this.getter.messagePayloadCompressedSize(request));
        if (this.operation == MessageOperation.RECEIVE || this.operation == MessageOperation.PROCESS) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_OPERATION, (Object)this.operation.operationName());
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_MESSAGE_ID, (Object)this.getter.messageId(request, response));
    }

    public SpanKey internalGetSpanKey() {
        switch (this.operation) {
            case SEND: {
                return SpanKey.PRODUCER;
            }
            case RECEIVE: {
                return SpanKey.CONSUMER_RECEIVE;
            }
            case PROCESS: {
                return SpanKey.CONSUMER_PROCESS;
            }
        }
        throw new IllegalStateException("Can't possibly happen");
    }
}

