/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpClientMetrics_State;
import io.opentelemetry.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpClientMetrics
implements RequestListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_CLIENT_REQUEST_METRICS_STATE = ContextKey.named((String)"http-client-request-metrics-state");
    private static final Logger logger = Logger.getLogger(HttpClientMetrics.class.getName());
    private final DoubleHistogram duration;

    public static RequestMetrics get() {
        return HttpClientMetrics::new;
    }

    private HttpClientMetrics(Meter meter) {
        this.duration = meter.histogramBuilder("http.client.duration").setUnit("ms").setDescription("The duration of the outbound HTTP request").build();
    }

    public Context start(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_STATE, (Object)new AutoValue_HttpClientMetrics_State(startAttributes, startNanos));
    }

    public void end(Context context, Attributes endAttributes, long endNanos) {
        State state = (State)context.get(HTTP_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, TemporaryMetricsView.applyClientDurationView(state.startAttributes(), endAttributes), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

