/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientHttpAttributesExtractor;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientNetAttributesExtractor;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientRequest;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientTracing;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;

public final class ApacheHttpClientTracingBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.apache-httpclient-4.3";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse>> additionalExtractors = new ArrayList<AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse>>();
    private CapturedHttpHeaders capturedHttpHeaders = CapturedHttpHeaders.client((Config)Config.get());

    ApacheHttpClientTracingBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public ApacheHttpClientTracingBuilder addAttributeExtractor(AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    public ApacheHttpClientTracingBuilder captureHttpHeaders(CapturedHttpHeaders capturedHttpHeaders) {
        this.capturedHttpHeaders = capturedHttpHeaders;
        return this;
    }

    public ApacheHttpClientTracing build() {
        ApacheHttpClientHttpAttributesExtractor httpAttributesExtractor = new ApacheHttpClientHttpAttributesExtractor(this.capturedHttpHeaders);
        SpanNameExtractor spanNameExtractor = HttpSpanNameExtractor.create((HttpCommonAttributesExtractor)httpAttributesExtractor);
        SpanStatusExtractor spanStatusExtractor = HttpSpanStatusExtractor.create((HttpClientAttributesExtractor)httpAttributesExtractor);
        ApacheHttpClientNetAttributesExtractor netAttributesExtractor = new ApacheHttpClientNetAttributesExtractor();
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanNameExtractor).setSpanStatusExtractor(spanStatusExtractor).addAttributesExtractor((AttributesExtractor)httpAttributesExtractor).addAttributesExtractor((AttributesExtractor)netAttributesExtractor).addAttributesExtractors(this.additionalExtractors).newInstrumenter(SpanKindExtractor.alwaysClient());
        return new ApacheHttpClientTracing((Instrumenter<ApacheHttpClientRequest, HttpResponse>)instrumenter, this.openTelemetry.getPropagators());
    }
}

