/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientRequest;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;

final class ApacheHttpClientHttpAttributesExtractor
extends HttpClientAttributesExtractor<ApacheHttpClientRequest, HttpResponse> {
    ApacheHttpClientHttpAttributesExtractor(CapturedHttpHeaders capturedHttpHeaders) {
        super(capturedHttpHeaders);
    }

    protected String method(ApacheHttpClientRequest request) {
        return request.getMethod();
    }

    @Nullable
    protected String url(ApacheHttpClientRequest request) {
        return request.getUrl();
    }

    protected List<String> requestHeader(ApacheHttpClientRequest request, String name) {
        return request.getHeader(name);
    }

    @Nullable
    protected Long requestContentLength(ApacheHttpClientRequest request, @Nullable HttpResponse response) {
        return null;
    }

    @Nullable
    protected Long requestContentLengthUncompressed(ApacheHttpClientRequest request, @Nullable HttpResponse response) {
        return null;
    }

    protected Integer statusCode(ApacheHttpClientRequest request, HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    @Nullable
    protected String flavor(ApacheHttpClientRequest request, @Nullable HttpResponse response) {
        return request.getFlavor();
    }

    @Nullable
    protected Long responseContentLength(ApacheHttpClientRequest request, HttpResponse response) {
        return null;
    }

    @Nullable
    protected Long responseContentLengthUncompressed(ApacheHttpClientRequest request, HttpResponse response) {
        return null;
    }

    protected List<String> responseHeader(ApacheHttpClientRequest request, HttpResponse response, String name) {
        return ApacheHttpClientRequest.headersToList(response.getHeaders(name));
    }
}

