/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientRequest;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientTracingBuilder;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.TracingHttpClientBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class ApacheHttpClientTracing {
    private final Instrumenter<ApacheHttpClientRequest, HttpResponse> instrumenter;
    private final ContextPropagators propagators;

    public static ApacheHttpClientTracing create(OpenTelemetry openTelemetry) {
        return ApacheHttpClientTracing.builder(openTelemetry).build();
    }

    public static ApacheHttpClientTracingBuilder builder(OpenTelemetry openTelemetry) {
        return new ApacheHttpClientTracingBuilder(openTelemetry);
    }

    ApacheHttpClientTracing(Instrumenter<ApacheHttpClientRequest, HttpResponse> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    public CloseableHttpClient newHttpClient() {
        return this.newHttpClientBuilder().build();
    }

    public HttpClientBuilder newHttpClientBuilder() {
        return new TracingHttpClientBuilder(this.instrumenter, this.propagators);
    }
}

