/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.test.shared.compiler;

import io.openmanufacturing.sds.aspectmodel.java.QualifiedName;
import io.openmanufacturing.sds.test.shared.compiler.CompilerInput;
import io.openmanufacturing.sds.test.shared.compiler.InMemoryClassFileManager;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ToolProvider;

public class JavaCompiler {
    public static Map<QualifiedName, Class<?>> compile(List<QualifiedName> loadOrder, Map<QualifiedName, String> sources, List<String> predefinedClasses) {
        javax.tools.JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        InMemoryClassFileManager manager = new InMemoryClassFileManager(compiler.getStandardFileManager(null, null, null));
        List compilerInput = loadOrder.stream().map(key -> new CompilerInput(key.toString(), (String)sources.get(key))).collect(Collectors.toList());
        compiler.getTask(null, manager, new DiagnosticListener(), null, null, compilerInput).call();
        return loadOrder.stream().collect(Collectors.toMap(Function.identity(), qualifiedName -> JavaCompiler.defineAndLoad(qualifiedName, manager)));
    }

    private static <T> Class<T> defineAndLoad(QualifiedName className, final InMemoryClassFileManager manager) {
        try {
            return new ClassLoader(){

                @Override
                protected Class<?> findClass(String name) {
                    byte[] classBytes = manager.getOutput(name).getBytes();
                    return this.defineClass(name, classBytes, 0, classBytes.length);
                }
            }.loadClass(className.toString());
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class DiagnosticListener
    implements javax.tools.DiagnosticListener<FileObject> {
        private DiagnosticListener() {
        }

        @Override
        public void report(Diagnostic<? extends FileObject> diagnostic) {
            System.out.println(diagnostic);
        }
    }
}

