/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.test.shared.arbitraries;

import java.math.BigInteger;
import java.time.Month;
import java.time.YearMonth;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.Provide;
import net.jqwik.api.Tuple;

public interface XsdArbitraries {
    public DatatypeFactory getDatatypeFactory();

    @Provide
    default public Arbitrary<Boolean> anyBoolean() {
        return Arbitraries.of((Object[])new Boolean[]{true, false});
    }

    @Provide
    default public Arbitrary<Short> anyUnsignedByte() {
        return Arbitraries.shorts().between((short)0, (short)255);
    }

    @Provide
    default public Arbitrary<Integer> anyUnsignedShort() {
        return Arbitraries.integers().between(0, 65535);
    }

    @Provide
    default public Arbitrary<BigInteger> anyUnsignedLong() {
        return Arbitraries.bigIntegers().between(BigInteger.ZERO, new BigInteger("18446744073709551615"));
    }

    @Provide
    default public Arbitrary<BigInteger> anyPositiveInteger() {
        return Arbitraries.bigIntegers().filter(value -> value.compareTo(BigInteger.ZERO) > 0);
    }

    @Provide
    default public Arbitrary<BigInteger> anyNonNegativeInteger() {
        return Arbitraries.bigIntegers().filter(value -> value.compareTo(BigInteger.ZERO) >= 0);
    }

    @Provide
    default public Arbitrary<String> anyHexBinary() {
        return Arbitraries.strings().ofMinLength(1).map(string -> DatatypeConverter.printHexBinary((byte[])string.getBytes()));
    }

    @Provide
    default public Arbitrary<String> anyBase64Binary() {
        return Arbitraries.strings().ofMinLength(1).map(string -> DatatypeConverter.printBase64Binary((byte[])string.getBytes()));
    }

    @Provide
    default public Arbitrary<Integer> anyYear() {
        return Arbitraries.integers().between(1970, 2999);
    }

    @Provide
    default public Arbitrary<Integer> anyMonth() {
        return Arbitraries.integers().between(1, 12);
    }

    @Provide
    default public Arbitrary<Integer> anyDayInMonth() {
        return Arbitraries.integers().between(1, 31);
    }

    @Provide
    default public Arbitrary<Integer> anyDay(int year, int month) {
        return Arbitraries.integers().between(1, YearMonth.of(year, month).lengthOfMonth());
    }

    @Provide
    default public Arbitrary<Integer> anyTimezone() {
        return Arbitraries.integers().between(-500, 500);
    }

    @Provide
    default public Arbitrary<Integer> anyHour() {
        return Arbitraries.integers().between(0, 23);
    }

    @Provide
    default public Arbitrary<Integer> anyMinute() {
        return Arbitraries.integers().between(0, 59);
    }

    @Provide
    default public Arbitrary<Integer> anySecond() {
        return Arbitraries.integers().between(0, 59);
    }

    @Provide
    default public Arbitrary<Integer> anyMillisecond() {
        return Arbitraries.integers().between(0, 999);
    }

    @Provide
    default public Arbitrary<Tuple.Tuple3<Integer, Integer, Integer>> anyYearMonthDay() {
        return this.anyYear().flatMap(year -> this.anyMonth().flatMap(month -> this.anyDay((int)year, (int)month).map(day -> Tuple.of((Object)year, (Object)month, (Object)day))));
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyDate() {
        return Combinators.combine(this.anyYearMonthDay(), this.anyTimezone()).as((yearMonthDay, timezone) -> this.getDatatypeFactory().newXMLGregorianCalendarDate((Integer)yearMonthDay.get1(), (Integer)yearMonthDay.get2(), (Integer)yearMonthDay.get3(), (int)timezone));
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyTime() {
        return Combinators.combine(this.anyHour(), this.anyMinute(), this.anySecond(), this.anyTimezone()).as(this.getDatatypeFactory()::newXMLGregorianCalendarTime);
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyDateTime() {
        return Combinators.combine(this.anyYearMonthDay(), this.anyHour(), this.anyMinute(), this.anySecond(), this.anyMillisecond(), this.anyTimezone()).as((yearMonthDay, hour, minute, second, millisecond, timezone) -> this.getDatatypeFactory().newXMLGregorianCalendar((Integer)yearMonthDay.get1(), (int)((Integer)yearMonthDay.get2()), (int)((Integer)yearMonthDay.get3()), (int)hour, (int)minute, (int)second, (int)millisecond, (int)timezone));
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyDateTimeStamp() {
        return this.anyDateTime();
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyGYear() {
        return Combinators.combine(this.anyYear(), (Arbitrary)this.anyTimezone().optional()).as((year, optionalTimezone) -> {
            int timezone = optionalTimezone.orElse(Integer.MIN_VALUE);
            return this.getDatatypeFactory().newXMLGregorianCalendar((int)year, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, timezone);
        });
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyGMonth() {
        return Combinators.combine(this.anyMonth(), (Arbitrary)this.anyTimezone().optional()).as((month, optionalTimezone) -> {
            int timezone = optionalTimezone.orElse(Integer.MIN_VALUE);
            return this.getDatatypeFactory().newXMLGregorianCalendar(Integer.MIN_VALUE, (int)month, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, timezone);
        });
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyGDay() {
        return Combinators.combine(this.anyDayInMonth(), (Arbitrary)this.anyTimezone().optional()).as((day, optionalTimezone) -> {
            int timezone = optionalTimezone.orElse(Integer.MIN_VALUE);
            return this.getDatatypeFactory().newXMLGregorianCalendar(Integer.MIN_VALUE, Integer.MIN_VALUE, (int)day, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, timezone);
        });
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyGYearMonth() {
        return Combinators.combine(this.anyYear(), this.anyMonth(), (Arbitrary)this.anyTimezone().optional()).as((year, month, optionalTimezone) -> {
            int timezone = optionalTimezone.orElse(Integer.MIN_VALUE);
            return this.getDatatypeFactory().newXMLGregorianCalendar((int)year, (int)month, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, timezone);
        });
    }

    @Provide
    default public Arbitrary<Tuple.Tuple2<Integer, Integer>> anyMonthDay() {
        return Combinators.combine(this.anyMonth(), this.anyDayInMonth()).as(Tuple::of).filter(tuple -> {
            int month = (Integer)tuple.get1();
            int day = (Integer)tuple.get2();
            if (month == Month.FEBRUARY.getValue()) {
                return day <= 29;
            }
            if (Stream.of(Month.APRIL, Month.JUNE, Month.SEPTEMBER, Month.NOVEMBER).anyMatch(theMonth -> theMonth.getValue() == month)) {
                return day <= 30;
            }
            return day <= 31;
        });
    }

    @Provide
    default public Arbitrary<XMLGregorianCalendar> anyGMonthDay() {
        return Combinators.combine(this.anyMonthDay(), (Arbitrary)this.anyTimezone().optional()).as((monthDay, optionalTimezone) -> {
            int timezone = optionalTimezone.orElse(Integer.MIN_VALUE);
            return this.getDatatypeFactory().newXMLGregorianCalendar(Integer.MIN_VALUE, (int)((Integer)monthDay.get1()), (int)((Integer)monthDay.get2()), Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, timezone);
        });
    }

    @Provide
    default public Arbitrary<Duration> anyDuration() {
        return Arbitraries.longs().between(0L, 10000000L).map(this.getDatatypeFactory()::newDuration);
    }

    @Provide
    default public Arbitrary<Duration> anyYearMonthDuration() {
        return Combinators.combine(this.anyBoolean(), this.anyYear(), this.anyMonth()).as(this.getDatatypeFactory()::newDurationYearMonth);
    }

    @Provide
    default public Arbitrary<Duration> anyDayTimeDuration() {
        return Combinators.combine(this.anyBoolean(), this.anyDayInMonth(), this.anyHour(), this.anyMinute(), this.anySecond()).as(this.getDatatypeFactory()::newDurationDayTime);
    }
}

