/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.test.shared.arbitraries;

import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.Provide;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;

public interface UriArbitraries {
    @Provide
    default public Arbitrary<String> anyIpV4Address() {
        IntegerArbitrary numericPart = Arbitraries.integers().between(0, 255);
        return Combinators.combine((Arbitrary)numericPart, (Arbitrary)numericPart, (Arbitrary)numericPart, (Arbitrary)numericPart).as((part1, part2, part3, part4) -> String.format("%d.%d.%d.%d", part1, part2, part3, part3));
    }

    @Provide
    default public Arbitrary<String> anyIpV6Address() {
        return Arbitraries.of((Object[])new String[]{"1:2:3:4:5:6:7:8", "1:2:3:4:5:6:7::", "1:2:3:4:5:6::8", "1:2:3:4:5::7:8", "1:2:3:4:5::8", "1:2:3:4::6:7:8", "1:2:3:4::8", "1:2:3::5:6:7:8", "1:2:3::8", "1:2::4:5:6:7:8", "1:2::8", "1::", "1::3:4:5:6:7:8", "1::3:4:5:6:7:8", "1::4:5:6:7:8", "1::5:6:7:8", "1::6:7:8", "1::7:8", "1::8", "2001:db8:3:4::192.0.2.33", "64:ff9b::192.0.2.33", "::", "::255.255.255.255", "::2:3:4:5:6:7:8", "::2:3:4:5:6:7:8", "::8", "::ffff:0:255.255.255.255", "::ffff:255.255.255.255", "fe80::7:8%1", "fe80::7:8%eth0"}).map(pattern -> String.format("[%s]", pattern));
    }

    @Provide
    default public Arbitrary<String> anyHostname() {
        Arbitrary anyPart = Arbitraries.strings().alpha().withChars(new char[]{'-'}).ofMinLength(3).ofMaxLength(8).filter(part -> !part.startsWith("-") && !part.endsWith("-"));
        return anyPart.list().ofMinSize(1).ofMaxSize(4).map(list -> String.join((CharSequence)".", list));
    }

    @Provide
    default public Arbitrary<String> anyHost() {
        return Arbitraries.oneOf(this.anyHostname(), (Arbitrary[])new Arbitrary[]{this.anyIpV4Address(), this.anyIpV6Address()});
    }

    @Provide
    default public Arbitrary<String> anyUrlScheme() {
        return Arbitraries.of((Object[])new String[]{"http", "https"});
    }

    @Provide
    default public Arbitrary<String> anyUrlPath() {
        return Arbitraries.strings().alpha().numeric().ofMinLength(1).ofMaxLength(5).map(part -> "/" + part).list().ofMinSize(0).ofMaxSize(5).map(partsList -> String.join((CharSequence)"", partsList));
    }

    @Provide
    default public Arbitrary<String> anyUrlFragment() {
        return Arbitraries.strings().alpha().numeric().withChars(new char[]{'-', '_'}).ofMinLength(0).ofMaxLength(5).map(anchor -> !anchor.isEmpty() ? "#" + anchor : anchor);
    }

    @Provide
    default public Arbitrary<String> anyUrl() {
        return Combinators.combine(this.anyUrlScheme(), this.anyHost(), this.anyUrlPath(), this.anyUrlFragment()).as((protocol, hostname, path, fragment) -> String.format("%s://%s%s%s", protocol, hostname, path, fragment));
    }

    @Provide
    default public Arbitrary<String> anyUrn() {
        StringArbitrary anyIdentifier = Arbitraries.strings().ofMinLength(1).ofMaxLength(5).alpha();
        StringArbitrary anySpecificPart = Arbitraries.strings();
        return Combinators.combine((Arbitrary)anyIdentifier, (Arbitrary)anySpecificPart).as((identifier, specificPart) -> String.format("urn:%s:%s", identifier, specificPart));
    }

    @Provide
    default public Arbitrary<String> anyUri() {
        return Arbitraries.oneOf(this.anyUrl(), (Arbitrary[])new Arbitrary[]{this.anyUrn()});
    }
}

