/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.test.shared.arbitraries;

import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMM;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMMC;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMME;
import io.openmanufacturing.sds.test.shared.arbitraries.BammArbitraries;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.junit.jupiter.api.Assertions;

public abstract class PropertyBasedTest
implements BammArbitraries {
    private final DatatypeFactory datatypeFactory;
    private final Map<KnownVersion, BAMM> BAMM_VERSIONS = KnownVersion.getVersions().stream().collect(Collectors.toMap(Function.identity(), BAMM::new));
    private final Map<KnownVersion, BAMMC> BAMMC_VERSIONS = KnownVersion.getVersions().stream().collect(Collectors.toMap(Function.identity(), BAMMC::new));
    private final Map<KnownVersion, BAMME> BAMME_VERSIONS = KnownVersion.getVersions().stream().collect(Collectors.toMap(Function.identity(), version -> new BAMME(version, this.BAMM_VERSIONS.get(version))));

    public PropertyBasedTest() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException exception) {
            Assertions.fail((String)"Could not instantiate DatatypeFactory", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public BAMM bamm(KnownVersion metaModelVersion) {
        return this.BAMM_VERSIONS.get(metaModelVersion);
    }

    @Override
    public BAMMC bammc(KnownVersion metaModelVersion) {
        return this.BAMMC_VERSIONS.get(metaModelVersion);
    }

    @Override
    public BAMME bamme(KnownVersion metaModelVersion) {
        return this.BAMME_VERSIONS.get(metaModelVersion);
    }

    @Override
    public DatatypeFactory getDatatypeFactory() {
        return this.datatypeFactory;
    }
}

