/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.test.shared.arbitraries;

import com.google.common.collect.ImmutableMap;
import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.resolver.services.BammDataType;
import io.openmanufacturing.sds.aspectmodel.resolver.services.ExtendedXsdDataType;
import io.openmanufacturing.sds.aspectmodel.urn.AspectModelUrn;
import io.openmanufacturing.sds.aspectmodel.urn.ElementType;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMM;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMMC;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMME;
import io.openmanufacturing.sds.metamodel.Aspect;
import io.openmanufacturing.sds.metamodel.Characteristic;
import io.openmanufacturing.sds.metamodel.Entity;
import io.openmanufacturing.sds.metamodel.Operation;
import io.openmanufacturing.sds.metamodel.Property;
import io.openmanufacturing.sds.metamodel.Scalar;
import io.openmanufacturing.sds.metamodel.Type;
import io.openmanufacturing.sds.metamodel.impl.DefaultAspect;
import io.openmanufacturing.sds.metamodel.impl.DefaultCharacteristic;
import io.openmanufacturing.sds.metamodel.impl.DefaultEntity;
import io.openmanufacturing.sds.metamodel.impl.DefaultOperation;
import io.openmanufacturing.sds.metamodel.impl.DefaultProperty;
import io.openmanufacturing.sds.metamodel.impl.DefaultScalar;
import io.openmanufacturing.sds.metamodel.loader.MetaModelBaseAttributes;
import io.openmanufacturing.sds.test.shared.arbitraries.UriArbitraries;
import io.openmanufacturing.sds.test.shared.arbitraries.XsdArbitraries;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.Provide;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.rdf.model.Resource;

public interface BammArbitraries
extends UriArbitraries,
XsdArbitraries {
    public BAMM bamm(KnownVersion var1);

    public BAMMC bammc(KnownVersion var1);

    public BAMME bamme(KnownVersion var1);

    @Provide
    default public Arbitrary<Scalar> anyScalar() {
        Arbitrary uris = Arbitraries.of(ExtendedXsdDataType.supportedXsdTypes.stream().map(RDFDatatype::getURI).collect(Collectors.toList()));
        return Combinators.combine((Arbitrary)uris, this.anyMetaModelVersion()).as(DefaultScalar::new);
    }

    @Provide
    default public Arbitrary<KnownVersion> anyMetaModelVersion() {
        return Arbitraries.of((Object[])new KnownVersion[]{KnownVersion.getLatest()});
    }

    @Provide
    default public Arbitrary<String> anyModelElementVersion() {
        IntegerArbitrary major = Arbitraries.integers().greaterOrEqual(0);
        IntegerArbitrary minor = Arbitraries.integers().greaterOrEqual(0);
        IntegerArbitrary maintenance = Arbitraries.integers().greaterOrEqual(0);
        return Combinators.combine((Arbitrary)major, (Arbitrary)minor, (Arbitrary)maintenance).as((i1, i2, i3) -> String.format("%d.%d.%d", i1, i2, i3));
    }

    @Provide
    default public Arbitrary<String> anyNamespace() {
        return this.anyHostname().map(hostname -> {
            String[] parts = hostname.split("\\.");
            return IntStream.range(0, parts.length).mapToObj(index -> parts[parts.length - index - 1]).map(part -> part.replace("-", "_")).collect(Collectors.joining("."));
        });
    }

    @Provide
    default public Arbitrary<String> anyUpperCaseElementName() {
        return this.anyLowerCaseElementName().map(StringUtils::capitalize);
    }

    @Provide
    default public Arbitrary<String> anyLowerCaseElementName() {
        Arbitrary firstCharacter = Arbitraries.strings().ofMinLength(1).ofMaxLength(1).alpha().map(String::toLowerCase);
        StringArbitrary rest = Arbitraries.strings().ofMinLength(3).ofMaxLength(10).alpha().numeric();
        return Combinators.combine((Arbitrary)firstCharacter, (Arbitrary)rest).as((f, r) -> String.format("%s%s", f, r));
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyEntityUrnInMetaModelScope() {
        return this.anyMetaModelVersion().flatMap(metaModelVersion -> Arbitraries.of(this.bamme((KnownVersion)metaModelVersion).allEntities().map(Resource::getURI).map(AspectModelUrn::fromUrn).collect(Collectors.toList())));
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyCharacteristicUrnInMetaModelScope() {
        return this.anyMetaModelVersion().flatMap(metaModelVersion -> Arbitraries.of(this.bammc((KnownVersion)metaModelVersion).allCharacteristics().map(Resource::getURI).map(AspectModelUrn::fromUrn).collect(Collectors.toList())));
    }

    @Provide
    default public Arbitrary<String> anyPayloadName() {
        return Arbitraries.strings().ofMinLength(1).ofMaxLength(5).alpha().numeric().withChars(new char[]{'_', '-'});
    }

    @Provide
    default public Arbitrary<ElementType> anyTopLevelElementType() {
        return Arbitraries.of((Object[])TopLevelElementType.values()).map(type -> type.elementType);
    }

    @Provide
    default public Arbitrary<String> anyTopLevelElementName() {
        return this.anyUpperCaseElementName();
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyTopLevelElementUrnInItsOwnScope(TopLevelElementType type) {
        return Combinators.combine(this.anyNamespace(), this.anyTopLevelElementName(), this.anyModelElementVersion()).as((namespace, entityName, version) -> String.format("urn:bamm:%s:%s:%s:%s", namespace, type.elementType.getValue(), entityName, version)).map(AspectModelUrn::fromUrn);
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyEntityUrnInItsOwnScope() {
        return this.anyTopLevelElementUrnInItsOwnScope(TopLevelElementType.ENTITY);
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyCharacteristicUrnInItsOwnScope() {
        return this.anyTopLevelElementUrnInItsOwnScope(TopLevelElementType.CHARACTERISTIC);
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyAspectUrn() {
        return this.anyTopLevelElementUrnInItsOwnScope(TopLevelElementType.ASPECT_MODEL);
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyPropertyUrn() {
        return this.anyLowerCaseModelElementUrnInTopLevelElementScope();
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyOperationUrn() {
        return this.anyLowerCaseModelElementUrnInTopLevelElementScope();
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyCharacteristicUrn() {
        return Arbitraries.oneOf(this.anyCharacteristicUrnInMetaModelScope(), (Arbitrary[])new Arbitrary[]{this.anyUpperCaseModelElementUrnInTopLevelElementScope(), this.anyCharacteristicUrnInItsOwnScope()});
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyEntityUrn() {
        return Arbitraries.oneOf(this.anyEntityUrnInMetaModelScope(), (Arbitrary[])new Arbitrary[]{this.anyUpperCaseModelElementUrnInTopLevelElementScope(), this.anyEntityUrnInItsOwnScope()});
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyModelElementUrnInTopLevelElementScope(Arbitrary<String> anyElementName) {
        return Combinators.combine(this.anyNamespace(), this.anyTopLevelElementType(), this.anyTopLevelElementName(), this.anyModelElementVersion(), anyElementName).as((namespace, containingElementType, containingElementName, version, elementName) -> String.format("urn:bamm:%s:%s:%s:%s#%s", namespace, containingElementType.getValue(), containingElementName, version, elementName)).map(AspectModelUrn::fromUrn);
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyLowerCaseModelElementUrnInTopLevelElementScope() {
        return this.anyModelElementUrnInTopLevelElementScope(this.anyLowerCaseElementName());
    }

    @Provide
    default public Arbitrary<AspectModelUrn> anyUpperCaseModelElementUrnInTopLevelElementScope() {
        return this.anyModelElementUrnInTopLevelElementScope(this.anyUpperCaseElementName());
    }

    @Provide
    default public Arbitrary<Locale> anyLocale() {
        return Arbitraries.of((Object[])new Locale[]{Locale.ENGLISH, Locale.GERMAN});
    }

    @Provide
    default public Arbitrary<Map<Locale, String>> anyLocalizedString() {
        StringArbitrary values = Arbitraries.strings().ofMinLength(1).ofMaxLength(10);
        return Arbitraries.maps(this.anyLocale(), (Arbitrary)values);
    }

    @Provide
    default public Arbitrary<Map<Locale, String>> anyPreferredNames() {
        return this.anyLocalizedString();
    }

    @Provide
    default public Arbitrary<Map<Locale, String>> anyDescriptions() {
        return this.anyLocalizedString();
    }

    @Provide
    default public Arbitrary<List<String>> anySee() {
        return this.anyUri().list().ofMaxSize(3);
    }

    @Provide
    default public Arbitrary<Characteristic> anyCharacteristic() {
        return Combinators.combine(this.anyMetaModelVersion(), this.anyCharacteristicUrn(), this.anyPreferredNames(), this.anyDescriptions(), this.anySee(), this.anyScalar()).as((metaModelVersion, characteristicUrn, preferredNames, descriptions, see, dataType) -> {
            MetaModelBaseAttributes baseAttributes = new MetaModelBaseAttributes(metaModelVersion, characteristicUrn, characteristicUrn.getName(), preferredNames, descriptions, see);
            return new DefaultCharacteristic(baseAttributes, Optional.of(dataType));
        });
    }

    @Provide
    default public Arbitrary<Aspect> anyAspect() {
        return Combinators.combine(this.anyMetaModelVersion(), this.anyAspectUrn(), this.anyPreferredNames(), this.anyDescriptions(), this.anySee(), (Arbitrary)this.anyProperty().list().ofMinSize(1).ofMaxSize(3), (Arbitrary)this.anyOperation().list().ofMaxSize(3)).as((metaModelVersion, aspectUrn, preferredNames, descriptions, see, properties, operations) -> {
            MetaModelBaseAttributes baseAttributes = new MetaModelBaseAttributes(metaModelVersion, aspectUrn, aspectUrn.getName(), preferredNames, descriptions, see);
            return new DefaultAspect(baseAttributes, properties, operations, false);
        });
    }

    @Provide
    default public Arbitrary<Operation> anyOperation() {
        return Combinators.combine(this.anyMetaModelVersion(), this.anyOperationUrn(), this.anyPreferredNames(), this.anyDescriptions(), this.anySee(), (Arbitrary)this.anyProperty().list().ofMinSize(1).ofMaxSize(3), (Arbitrary)this.anyProperty().optional()).as((metaModelVersion, operationUrn, preferredNames, descriptions, see, inputs, output) -> {
            MetaModelBaseAttributes baseAttributes = new MetaModelBaseAttributes(metaModelVersion, operationUrn, operationUrn.getName(), preferredNames, descriptions, see);
            return new DefaultOperation(baseAttributes, inputs, output);
        });
    }

    @Provide
    default public Arbitrary<Property> anyProperty() {
        return Combinators.combine(this.anyMetaModelVersion(), this.anyPropertyUrn(), this.anyPreferredNames(), this.anyDescriptions(), this.anySee(), this.anyCharacteristic(), this.anyPayloadName()).as((metaModelVersion, propertyUrn, preferredNames, descriptions, see, characteristic, payloadName) -> {
            MetaModelBaseAttributes baseAttributes = new MetaModelBaseAttributes(metaModelVersion, propertyUrn, propertyUrn.getName(), preferredNames, descriptions, see);
            return new DefaultProperty(baseAttributes, characteristic, Optional.empty(), Optional.empty(), false, false, Optional.of(payloadName));
        });
    }

    @Provide
    default public Arbitrary<Entity> anyEntity() {
        return Combinators.combine(this.anyMetaModelVersion(), this.anyEntityUrn(), this.anyPreferredNames(), this.anyDescriptions(), this.anySee(), (Arbitrary)this.anyProperty().list().ofMinSize(1).ofMaxSize(3)).as((metaModelVersion, entityUrn, preferredNames, descriptions, see, properties) -> {
            MetaModelBaseAttributes baseAttributes = new MetaModelBaseAttributes(metaModelVersion, entityUrn, entityUrn.getName(), preferredNames, descriptions, see);
            return new DefaultEntity(baseAttributes, properties, Optional.empty());
        });
    }

    @Provide
    default public Arbitrary<? extends Type> anyType() {
        return Arbitraries.oneOf((Arbitrary)this.anyScalar().map(x -> x), (Arbitrary[])new Arbitrary[]{this.anyEntity().map(x -> x)});
    }

    @Provide
    default public Arbitrary<Object> anyValueForRdfType(RDFDatatype rdfDatatype) {
        StringArbitrary anyString = Arbitraries.strings().ofMinLength(1).ofMaxLength(25);
        switch (rdfDatatype.getURI().split("#")[1]) {
            case "boolean": {
                return this.anyBoolean().map(x -> x);
            }
            case "decimal": 
            case "integer": {
                return Arbitraries.bigIntegers().map(x -> x);
            }
            case "double": {
                return Arbitraries.doubles().map(x -> x);
            }
            case "float": {
                return Arbitraries.floats().map(x -> x);
            }
            case "date": {
                return this.anyDate().map(x -> x);
            }
            case "time": {
                return this.anyTime().map(x -> x);
            }
            case "anyDateTime": {
                return this.anyDateTime().map(x -> x);
            }
            case "anyDateTimeStamp": {
                return this.anyDateTimeStamp().map(x -> x);
            }
            case "gYear": {
                return this.anyGYear().map(x -> x);
            }
            case "gMonth": {
                return this.anyGMonth().map(x -> x);
            }
            case "gDay": {
                return this.anyGDay().map(x -> x);
            }
            case "gYearMonth": {
                return this.anyGYearMonth().map(x -> x);
            }
            case "gMonthDay": {
                return this.anyGMonthDay().map(x -> x);
            }
            case "duration": {
                return this.anyDuration().map(x -> x);
            }
            case "yearMonthDuation": {
                return this.anyYearMonthDuration().map(x -> x);
            }
            case "dayTimeDuration": {
                return this.anyDayTimeDuration().map(x -> x);
            }
            case "byte": {
                return Arbitraries.bytes().map(x -> x);
            }
            case "short": {
                return Arbitraries.shorts().map(x -> x);
            }
            case "unsignedByte": {
                return this.anyUnsignedByte().map(x -> x);
            }
            case "int": {
                return Arbitraries.integers().map(x -> x);
            }
            case "unsignedShort": {
                return this.anyUnsignedShort().map(x -> x);
            }
            case "long": {
                return Arbitraries.longs().map(x -> x);
            }
            case "unsignedLong": {
                return this.anyUnsignedLong().map(x -> x);
            }
            case "positiveInteger": {
                return this.anyPositiveInteger().map(x -> x);
            }
            case "nonNegativeInteger": {
                return this.anyNonNegativeInteger().map(x -> x);
            }
            case "hexBinary": {
                return this.anyHexBinary().map(x -> x);
            }
            case "base64Binary": {
                return this.anyBase64Binary().map(x -> x);
            }
            case "anyURI": {
                return this.anyUri().map(x -> x);
            }
            case "curie": {
                return this.anyMetaModelVersion().map(BammDataType::curie).map(x -> x);
            }
            case "langString": {
                return Combinators.combine((Arbitrary)anyString, this.anyLocale()).as((string, locale) -> Map.of(locale, string)).map(x -> x);
            }
        }
        return anyString.map(x -> x);
    }

    @Provide
    default public Arbitrary<Map<String, Object>> anyEntityInstance(Entity entity) {
        Arbitrary anyEntityInstanceIdentifier = this.anyMetaModelVersion().flatMap(metaModelVersion -> {
            Arbitrary key = Arbitraries.constant((Object)this.bamm((KnownVersion)metaModelVersion)).map(BAMM::name).map(Object::toString);
            Arbitrary values = this.anyLowerCaseElementName().map(x -> x);
            return Arbitraries.maps((Arbitrary)key, (Arbitrary)values).ofSize(1);
        });
        Arbitrary anyEntityInstanceKeyValues = Arbitraries.of((List)entity.getProperties()).flatMap(property -> {
            Arbitrary key = Arbitraries.constant((Object)property.getName());
            Arbitrary values = property.getDataType().map(this::anyValueForType).orElse(Arbitraries.of((Object[])new Object[]{null}));
            return Arbitraries.maps((Arbitrary)key, (Arbitrary)values);
        });
        return Combinators.combine((Arbitrary)anyEntityInstanceIdentifier, (Arbitrary)anyEntityInstanceKeyValues).as((identifierMap, propertiesMap) -> ImmutableMap.builder().putAll(identifierMap).putAll(propertiesMap).build());
    }

    @Provide
    default public Arbitrary<Object> anyValueForType(Type type) {
        if (type.isScalar()) {
            return this.anyValueForScalarType((Scalar)type);
        }
        return this.anyEntityInstance((Entity)type).map(x -> x);
    }

    @Provide
    default public Arbitrary<Object> anyValueForScalarType(Scalar type) {
        return ExtendedXsdDataType.supportedXsdTypes.stream().filter(dataType -> dataType.getURI().equals(type.getUrn())).map(this::anyValueForRdfType).findFirst().orElseThrow(() -> new RuntimeException("Could not generate values for type " + type));
    }

    @Provide
    default public Arbitrary<Tuple.Tuple2<Type, Object>> anyValidTypeValuePair() {
        return this.anyType().flatMap(type -> this.anyValueForType((Type)type).map(value -> Tuple.of((Object)type, (Object)value)));
    }

    public static enum TopLevelElementType {
        ASPECT_MODEL(ElementType.ASPECT_MODEL),
        ENTITY(ElementType.ENTITY),
        CHARACTERISTIC(ElementType.CHARACTERISTIC);

        ElementType elementType;

        private TopLevelElementType(ElementType elementType) {
            this.elementType = elementType;
        }
    }
}

