/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.relation;

import io.objectbox.annotation.apihint.Experimental;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Experimental
public interface ListFactory
extends Serializable {
    public <T> List<T> createList();

    public static class CopyOnWriteArrayListFactory
    implements ListFactory {
        private static final long serialVersionUID = 1888039726372206411L;

        @Override
        public <T> List<T> createList() {
            return new CopyOnWriteArrayList();
        }
    }

    public static class ArrayListFactory
    implements ListFactory {
        private static final long serialVersionUID = 8247662514375611729L;

        @Override
        public <T> List<T> createList() {
            return new ArrayList();
        }
    }
}

