/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.reactive;

import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataPublisher;
import io.objectbox.reactive.DataSubscription;
import javax.annotation.Nullable;

class DataSubscriptionImpl<T>
implements DataSubscription {
    private volatile boolean canceled;
    private DataPublisher<T> publisher;
    private Object publisherParam;
    private DataObserver<T> observer;

    DataSubscriptionImpl(DataPublisher<T> publisher, @Nullable Object publisherParam, DataObserver<T> observer) {
        this.publisher = publisher;
        this.publisherParam = publisherParam;
        this.observer = observer;
    }

    @Override
    public synchronized void cancel() {
        this.canceled = true;
        if (this.publisher != null) {
            this.publisher.unsubscribe(this.observer, this.publisherParam);
            this.publisher = null;
            this.observer = null;
            this.publisherParam = null;
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }
}

