/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle.transform;

import io.objectbox.gradle.transform.ClassProber;
import io.objectbox.gradle.transform.ClassTransformer;
import io.objectbox.gradle.transform.ObjectBoxJavaTransform;
import io.objectbox.gradle.transform.TransformException;
import io.objectbox.logging.Logging;
import io.objectbox.reporting.BasicBuildTracker;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/objectbox/gradle/transform/ObjectBoxJavaTransform;", "", "debug", "", "(Z)V", "transform", "", "compiledClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "outDir", "Ljava/io/File;", "copyNonTransformed", "objectbox-code-modifier"})
@SourceDebugExtension(value={"SMAP\nObjectBoxJavaTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectBoxJavaTransform.kt\nio/objectbox/gradle/transform/ObjectBoxJavaTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,69:1\n1855#2,2:70\n1855#2:72\n1856#2:75\n1295#3,2:73\n*S KotlinDebug\n*F\n+ 1 ObjectBoxJavaTransform.kt\nio/objectbox/gradle/transform/ObjectBoxJavaTransform\n*L\n42#1:70,2\n50#1:72\n50#1:75\n52#1:73,2\n*E\n"})
public final class ObjectBoxJavaTransform {
    private final boolean debug;

    public ObjectBoxJavaTransform(boolean debug) {
        this.debug = debug;
    }

    public final void transform(@NotNull ConfigurableFileCollection compiledClasses, @Nullable File outDir, boolean copyNonTransformed) {
        Intrinsics.checkNotNullParameter((Object)compiledClasses, (String)"compiledClasses");
        try {
            Set set = compiledClasses.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"compiledClasses.files");
            List byteCodeDirs = CollectionsKt.reversed((Iterable)CollectionsKt.toList((Iterable)set));
            Iterable $this$forEach$iv = byteCodeDirs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.isFile()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"jar")) continue;
                Logging.logWarning("Detected JAR file in transform classpath (" + it + "), relations might not work, please report this to us.");
            }
            List probedClasses = new ArrayList();
            ClassProber classProber = new ClassProber();
            Iterable $this$forEach$iv2 = byteCodeDirs;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                File byteCodeDir = (File)element$iv;
                boolean bl = false;
                if (this.debug) {
                    Logging.log("Detected byte code dir " + byteCodeDir.getPath());
                }
                Intrinsics.checkNotNullExpressionValue((Object)byteCodeDir, (String)"byteCodeDir");
                Sequence $this$forEach$iv3 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)byteCodeDir, null, (int)1, null)), (Function1)transform.2.1.INSTANCE);
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    File file = (File)element$iv2;
                    boolean bl2 = false;
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                    Collection collection = probedClasses;
                    File file2 = outDir;
                    if (file2 == null) {
                        file2 = byteCodeDir;
                    }
                    collection.add(classProber.probeClass(file, file2));
                }
            }
            new ClassTransformer(this.debug).transformOrCopyClasses(probedClasses, copyNonTransformed);
        }
        catch (Throwable e) {
            BasicBuildTracker buildTracker = new BasicBuildTracker("Transformer");
            if (e instanceof TransformException) {
                buildTracker.trackError("Transform failed", e);
            } else {
                buildTracker.trackFatal("Transform failed", e);
            }
            throw e;
        }
    }
}

