/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.HostsFileEntries;
import io.netty.resolver.HostsFileParser;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ResourcesUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class HostsFileParserTest {
    @Test
    public void testParse() throws IOException {
        String hostsString = "127.0.0.1 host1" + "\n" + "::1 host1" + "\n" + "\n" + "192.168.0.1\thost2" + "\n" + "#comment" + "\n" + " #comment  " + "\n" + "192.168.0.2  host3  #comment" + "\n" + "192.168.0.3  host4  host5 host6" + "\n" + "192.168.0.4  host4" + "\n" + "192.168.0.5  HOST7" + "\n" + "192.168.0.6  host7" + "\n";
        HostsFileEntries entries = HostsFileParser.parse((Reader)new BufferedReader(new StringReader(hostsString)));
        Map inet4Entries = entries.inet4Entries();
        Map inet6Entries = entries.inet6Entries();
        Assert.assertEquals((String)"Expected 7 IPv4 entries", (long)7L, (long)inet4Entries.size());
        Assert.assertEquals((String)"Expected 1 IPv6 entries", (long)1L, (long)inet6Entries.size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((Inet4Address)inet4Entries.get("host1")).getHostAddress());
        Assert.assertEquals((Object)"192.168.0.1", (Object)((Inet4Address)inet4Entries.get("host2")).getHostAddress());
        Assert.assertEquals((Object)"192.168.0.2", (Object)((Inet4Address)inet4Entries.get("host3")).getHostAddress());
        Assert.assertEquals((Object)"192.168.0.3", (Object)((Inet4Address)inet4Entries.get("host4")).getHostAddress());
        Assert.assertEquals((Object)"192.168.0.3", (Object)((Inet4Address)inet4Entries.get("host5")).getHostAddress());
        Assert.assertEquals((Object)"192.168.0.3", (Object)((Inet4Address)inet4Entries.get("host6")).getHostAddress());
        Assert.assertNotNull((String)"uppercase host doesn't resolve", inet4Entries.get("host7"));
        Assert.assertEquals((Object)"192.168.0.5", (Object)((Inet4Address)inet4Entries.get("host7")).getHostAddress());
        Assert.assertEquals((Object)"0:0:0:0:0:0:0:1", (Object)((Inet6Address)inet6Entries.get("host1")).getHostAddress());
    }

    @Test
    public void testParseUnicode() throws IOException {
        Charset unicodeCharset;
        try {
            unicodeCharset = Charset.forName("unicode");
        }
        catch (UnsupportedCharsetException e) {
            Assume.assumeNoException((Throwable)e);
            return;
        }
        HostsFileParserTest.testParseFile(HostsFileParser.parse((File)ResourcesUtil.getFile(this.getClass(), (String)"hosts-unicode"), (Charset[])new Charset[]{unicodeCharset}));
    }

    @Test
    public void testParseMultipleCharsets() throws IOException {
        Charset unicodeCharset;
        try {
            unicodeCharset = Charset.forName("unicode");
        }
        catch (UnsupportedCharsetException e) {
            Assume.assumeNoException((Throwable)e);
            return;
        }
        HostsFileParserTest.testParseFile(HostsFileParser.parse((File)ResourcesUtil.getFile(this.getClass(), (String)"hosts-unicode"), (Charset[])new Charset[]{CharsetUtil.UTF_8, CharsetUtil.ISO_8859_1, unicodeCharset}));
    }

    private static void testParseFile(HostsFileEntries entries) throws IOException {
        Map inet4Entries = entries.inet4Entries();
        Map inet6Entries = entries.inet6Entries();
        Assert.assertEquals((String)"Expected 2 IPv4 entries", (long)2L, (long)inet4Entries.size());
        Assert.assertEquals((String)"Expected 1 IPv6 entries", (long)1L, (long)inet6Entries.size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((Inet4Address)inet4Entries.get("localhost")).getHostAddress());
        Assert.assertEquals((Object)"255.255.255.255", (Object)((Inet4Address)inet4Entries.get("broadcasthost")).getHostAddress());
        Assert.assertEquals((Object)"0:0:0:0:0:0:0:1", (Object)((Inet6Address)inet6Entries.get("localhost")).getHostAddress());
    }
}

