/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.internal.ThreadExecutorMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadExecutorMapTest {
    private static final EventExecutor EVENT_EXECUTOR = new AbstractEventExecutor(){

        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        public boolean inEventLoop(Thread thread) {
            return false;
        }

        public boolean isShuttingDown() {
            return false;
        }

        public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public Future<?> terminationFuture() {
            throw new UnsupportedOperationException();
        }

        public boolean isShutdown() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
            return false;
        }

        public void execute(@NotNull Runnable command) {
            throw new UnsupportedOperationException();
        }
    };

    @Test
    public void testOldExecutorIsRestored() {
        Executor executor = ThreadExecutorMap.apply((Executor)ImmediateExecutor.INSTANCE, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        final Executor executor2 = ThreadExecutorMap.apply((Executor)ImmediateExecutor.INSTANCE, (EventExecutor)EVENT_EXECUTOR);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                executor2.execute(new Runnable(){

                    @Override
                    public void run() {
                        Assertions.assertSame((Object)EVENT_EXECUTOR, (Object)ThreadExecutorMap.currentExecutor());
                    }
                });
                Assertions.assertSame((Object)ImmediateEventExecutor.INSTANCE, (Object)ThreadExecutorMap.currentExecutor());
            }
        });
    }

    @Test
    public void testDecorateExecutor() {
        Executor executor = ThreadExecutorMap.apply((Executor)ImmediateExecutor.INSTANCE, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                Assertions.assertSame((Object)ImmediateEventExecutor.INSTANCE, (Object)ThreadExecutorMap.currentExecutor());
            }
        });
    }

    @Test
    public void testDecorateRunnable() {
        ThreadExecutorMap.apply((Runnable)new Runnable(){

            @Override
            public void run() {
                Assertions.assertSame((Object)ImmediateEventExecutor.INSTANCE, (Object)ThreadExecutorMap.currentExecutor());
            }
        }, (EventExecutor)ImmediateEventExecutor.INSTANCE).run();
    }

    @Test
    public void testDecorateThreadFactory() throws InterruptedException {
        ThreadFactory threadFactory = ThreadExecutorMap.apply((ThreadFactory)Executors.defaultThreadFactory(), (EventExecutor)ImmediateEventExecutor.INSTANCE);
        Thread thread = threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                Assertions.assertSame((Object)ImmediateEventExecutor.INSTANCE, (Object)ThreadExecutorMap.currentExecutor());
            }
        });
        thread.start();
        thread.join();
    }
}

