/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.SystemPropertyUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class SystemPropertyUtilTest {
    @BeforeEach
    public void clearSystemPropertyBeforeEach() {
        System.clearProperty("key");
    }

    @Test
    public void testGetWithKeyNull() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                SystemPropertyUtil.get(null, null);
            }
        });
    }

    @Test
    public void testGetWithKeyEmpty() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                SystemPropertyUtil.get((String)"", null);
            }
        });
    }

    @Test
    public void testGetDefaultValueWithPropertyNull() {
        Assertions.assertEquals((Object)"default", (Object)SystemPropertyUtil.get((String)"key", (String)"default"));
    }

    @Test
    public void testGetPropertyValue() {
        System.setProperty("key", "value");
        Assertions.assertEquals((Object)"value", (Object)SystemPropertyUtil.get((String)"key"));
    }

    @Test
    public void testGetBooleanDefaultValueWithPropertyNull() {
        Assertions.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
        Assertions.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
    }

    @Test
    public void testGetBooleanDefaultValueWithEmptyString() {
        System.setProperty("key", "");
        Assertions.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
        Assertions.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
    }

    @Test
    public void testGetBooleanWithTrueValue() {
        System.setProperty("key", "true");
        Assertions.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
        System.setProperty("key", "yes");
        Assertions.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
        System.setProperty("key", "1");
        Assertions.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
    }

    @Test
    public void testGetBooleanWithFalseValue() {
        System.setProperty("key", "false");
        Assertions.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
        System.setProperty("key", "no");
        Assertions.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
        System.setProperty("key", "0");
        Assertions.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
    }

    @Test
    public void testGetBooleanDefaultValueWithWrongValue() {
        System.setProperty("key", "abc");
        Assertions.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
        System.setProperty("key", "123");
        Assertions.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
    }

    @Test
    public void getIntDefaultValueWithPropertyNull() {
        Assertions.assertEquals((int)1, (int)SystemPropertyUtil.getInt((String)"key", (int)1));
    }

    @Test
    public void getIntWithPropertValueIsInt() {
        System.setProperty("key", "123");
        Assertions.assertEquals((int)123, (int)SystemPropertyUtil.getInt((String)"key", (int)1));
    }

    @Test
    public void getIntDefaultValueWithPropertValueIsNotInt() {
        System.setProperty("key", "NotInt");
        Assertions.assertEquals((int)1, (int)SystemPropertyUtil.getInt((String)"key", (int)1));
    }

    @Test
    public void getLongDefaultValueWithPropertyNull() {
        Assertions.assertEquals((long)1L, (long)SystemPropertyUtil.getLong((String)"key", (long)1L));
    }

    @Test
    public void getLongWithPropertValueIsLong() {
        System.setProperty("key", "123");
        Assertions.assertEquals((long)123L, (long)SystemPropertyUtil.getLong((String)"key", (long)1L));
    }

    @Test
    public void getLongDefaultValueWithPropertValueIsNotLong() {
        System.setProperty("key", "NotInt");
        Assertions.assertEquals((long)1L, (long)SystemPropertyUtil.getLong((String)"key", (long)1L));
    }
}

