/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.LongLongHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class LongLongHashMapTest {
    @Test
    public void zeroPutGetAndRemove() {
        LongLongHashMap map = new LongLongHashMap(-1L);
        Assertions.assertThat((long)map.put(0L, 42L)).isEqualTo(-1L);
        Assertions.assertThat((long)map.get(0L)).isEqualTo(42L);
        Assertions.assertThat((long)map.put(0L, 24L)).isEqualTo(42L);
        Assertions.assertThat((long)map.get(0L)).isEqualTo(24L);
        map.remove(0L);
        Assertions.assertThat((long)map.get(0L)).isEqualTo(-1L);
    }

    @Test
    public void mustHandleCollisions() {
        LongLongHashMap map = new LongLongHashMap(-1L);
        HashSet<Long> set = new HashSet<Long>();
        long v = 1L;
        for (int i = 0; i < 63; ++i) {
            Assertions.assertThat((long)map.put(v, v)).isEqualTo(-1L);
            set.add(v);
            v <<= 1;
        }
        for (Long value : set) {
            Assertions.assertThat((long)map.get(value.longValue())).isEqualTo((Object)value);
            Assertions.assertThat((long)map.put(value.longValue(), -value.longValue())).isEqualTo((Object)value);
            Assertions.assertThat((long)map.get(value.longValue())).isEqualTo(-value.longValue());
            map.remove(value.longValue());
            Assertions.assertThat((long)map.get(value.longValue())).isEqualTo(-1L);
        }
    }

    @Test
    public void randomOperations() {
        int operations = 6000;
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        HashMap<Long, Long> expected = new HashMap<Long, Long>();
        LongLongHashMap actual = new LongLongHashMap(-1L);
        PrimitiveIterator.OfLong itr = tlr.longs(0L, operations).limit(operations * 50).iterator();
        while (itr.hasNext()) {
            long value = itr.nextLong();
            if (expected.containsKey(value)) {
                Assertions.assertThat((long)actual.get(value)).isEqualTo(expected.get(value));
                if (tlr.nextBoolean()) {
                    actual.remove(value);
                    expected.remove(value);
                    Assertions.assertThat((long)actual.get(value)).isEqualTo(-1L);
                    continue;
                }
                long v = (Long)expected.get(value);
                Assertions.assertThat((long)actual.put(value, -v)).isEqualTo((Object)expected.put(value, -v));
                continue;
            }
            Assertions.assertThat((long)actual.get(value)).isEqualTo(-1L);
            Assertions.assertThat((long)actual.put(value, value)).isEqualTo(-1L);
            expected.put(value, value);
        }
    }
}

