/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import jdk.jfr.Enabled;
import jdk.jfr.Event;
import jdk.jfr.consumer.RecordingStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.JRE;

public class JfrEventSafeTest {
    @Test
    public void test() {
        if (PlatformDependent.isJfrEnabled()) {
            MyEvent event = new MyEvent();
            event.foo = "bar";
            event.commit();
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    public void simple() throws Throwable {
        try (RecordingStream stream = new RecordingStream();){
            stream.enable(MyEvent.class.getName());
            CompletableFuture result = new CompletableFuture();
            stream.onEvent(MyEvent.class.getName(), e -> result.complete(e.getString("foo")));
            stream.startAsync();
            MyEvent event = new MyEvent();
            event.foo = "bar";
            event.commit();
            Assertions.assertEquals((Object)"bar", result.get(10L, TimeUnit.SECONDS));
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    public void enableDefaults() throws Throwable {
        try (RecordingStream stream = new RecordingStream();){
            CompletableFuture result = new CompletableFuture();
            stream.onEvent(DisabledEvent.class.getName(), e -> result.completeExceptionally(new Exception("Event mistakenly fired")));
            stream.onEvent(MyEvent.class.getName(), e -> result.complete(e.getString("foo")));
            stream.startAsync();
            DisabledEvent disabled = new DisabledEvent();
            disabled.foo = "baz";
            disabled.commit();
            MyEvent event = new MyEvent();
            event.foo = "bar";
            event.commit();
            Assertions.assertEquals((Object)"bar", result.get(10L, TimeUnit.SECONDS));
        }
    }

    @Enabled(value=false)
    static final class DisabledEvent
    extends Event {
        String foo;

        DisabledEvent() {
        }
    }

    static final class MyEvent
    extends Event {
        String foo;

        MyEvent() {
        }
    }
}

