/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.AppendableCharSequence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AppendableCharSequenceTest {
    @Test
    public void testSimpleAppend() {
        AppendableCharSequenceTest.testSimpleAppend0(new AppendableCharSequence(128));
    }

    @Test
    public void testAppendString() {
        AppendableCharSequenceTest.testAppendString0(new AppendableCharSequence(128));
    }

    @Test
    public void testAppendAppendableCharSequence() {
        AppendableCharSequence seq = new AppendableCharSequence(128);
        String text = "testdata";
        AppendableCharSequence seq2 = new AppendableCharSequence(128);
        seq2.append((CharSequence)text);
        seq.append((CharSequence)seq2);
        Assertions.assertEquals((Object)text, (Object)seq.toString());
        Assertions.assertEquals((Object)text.substring(1, text.length() - 2), (Object)seq.substring(1, text.length() - 2));
        AppendableCharSequenceTest.assertEqualsChars(text, (CharSequence)seq);
    }

    @Test
    public void testSimpleAppendWithExpand() {
        AppendableCharSequenceTest.testSimpleAppend0(new AppendableCharSequence(2));
    }

    @Test
    public void testAppendStringWithExpand() {
        AppendableCharSequenceTest.testAppendString0(new AppendableCharSequence(2));
    }

    @Test
    public void testSubSequence() {
        AppendableCharSequence master = new AppendableCharSequence(26);
        master.append((CharSequence)"abcdefghijlkmonpqrstuvwxyz");
        Assertions.assertEquals((Object)"abcdefghij", (Object)master.subSequence(0, 10).toString());
    }

    @Test
    public void testEmptySubSequence() {
        AppendableCharSequence master = new AppendableCharSequence(26);
        master.append((CharSequence)"abcdefghijlkmonpqrstuvwxyz");
        AppendableCharSequence sub = master.subSequence(0, 0);
        Assertions.assertEquals((int)0, (int)sub.length());
        sub.append('b');
        Assertions.assertEquals((char)'b', (char)sub.charAt(0));
    }

    private static void testSimpleAppend0(AppendableCharSequence seq) {
        String text = "testdata";
        for (int i = 0; i < text.length(); ++i) {
            seq.append(text.charAt(i));
        }
        Assertions.assertEquals((Object)text, (Object)seq.toString());
        Assertions.assertEquals((Object)text.substring(1, text.length() - 2), (Object)seq.substring(1, text.length() - 2));
        AppendableCharSequenceTest.assertEqualsChars(text, (CharSequence)seq);
        seq.reset();
        Assertions.assertEquals((int)0, (int)seq.length());
    }

    private static void testAppendString0(AppendableCharSequence seq) {
        String text = "testdata";
        seq.append((CharSequence)text);
        Assertions.assertEquals((Object)text, (Object)seq.toString());
        Assertions.assertEquals((Object)text.substring(1, text.length() - 2), (Object)seq.substring(1, text.length() - 2));
        AppendableCharSequenceTest.assertEqualsChars(text, (CharSequence)seq);
        seq.reset();
        Assertions.assertEquals((int)0, (int)seq.length());
    }

    private static void assertEqualsChars(CharSequence seq1, CharSequence seq2) {
        Assertions.assertEquals((int)seq1.length(), (int)seq2.length());
        for (int i = 0; i < seq1.length(); ++i) {
            Assertions.assertEquals((char)seq1.charAt(i), (char)seq2.charAt(i));
        }
    }
}

