/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AutoScalingEventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.MultithreadEventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AutoScalingEventExecutorChooserFactoryTest {
    private static void busyTask(long duration, TimeUnit unit) {
        long endTime = System.nanoTime() + unit.toNanos(duration);
        while (System.nanoTime() < endTime) {
        }
    }

    @Test
    @Timeout(value=30L)
    void testScaleDown() throws InterruptedException {
        TestEventExecutorGroup group = new TestEventExecutorGroup(1, 3, 50L, TimeUnit.MILLISECONDS);
        try {
            AutoScalingEventExecutorChooserFactoryTest.startAllExecutors(group);
            Assertions.assertEquals((int)3, (int)group.activeExecutorCount());
            Thread.sleep(200L);
            Assertions.assertEquals((int)1, (int)group.activeExecutorCount());
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    void testScaleUp() throws InterruptedException {
        TestEventExecutorGroup group = new TestEventExecutorGroup(1, 3, 50L, TimeUnit.MILLISECONDS);
        try {
            AutoScalingEventExecutorChooserFactoryTest.startAllExecutors(group);
            Thread.sleep(200L);
            Assertions.assertEquals((int)1, (int)group.activeExecutorCount());
            TestEventExecutor activeExecutor = null;
            Iterator iterator = group.iterator();
            while (iterator.hasNext()) {
                EventExecutor exec = (EventExecutor)iterator.next();
                if (exec.isSuspended()) continue;
                activeExecutor = (TestEventExecutor)exec;
                break;
            }
            if (activeExecutor == null) {
                Assertions.fail((String)"Could not find an active executor to stress.");
            }
            activeExecutor.setHighLoad(true);
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(5L);
            while (group.activeExecutorCount() < 2 && System.nanoTime() < deadline) {
                Thread.sleep(50L);
            }
            Assertions.assertEquals((int)2, (int)group.activeExecutorCount(), (String)"Should scale up to 2 after stressing one executor.");
            Iterator iterator2 = group.iterator();
            while (iterator2.hasNext()) {
                EventExecutor exec = (EventExecutor)iterator2.next();
                if (exec.isSuspended()) continue;
                ((TestEventExecutor)exec).setHighLoad(true);
            }
            while (group.activeExecutorCount() < 3 && System.nanoTime() < deadline) {
                Thread.sleep(50L);
            }
            Assertions.assertEquals((int)3, (int)group.activeExecutorCount(), (String)"Should scale up to 3 after stressing two executors.");
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    @Test
    @Timeout(value=30L)
    void testScaleDownDoesNotGoBelowMinThreads() throws InterruptedException {
        TestEventExecutorGroup group = new TestEventExecutorGroup(2, 4, 50L, TimeUnit.MILLISECONDS);
        try {
            AutoScalingEventExecutorChooserFactoryTest.startAllExecutors(group);
            Thread.sleep(200L);
            Assertions.assertEquals((int)2, (int)group.activeExecutorCount(), (String)"Should not scale below minThreads");
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    void testScaleUpDoesNotExceedMaxThreads() throws Exception {
        TestEventExecutorGroup group = new TestEventExecutorGroup(1, 2, 50L, TimeUnit.MILLISECONDS);
        try {
            AutoScalingEventExecutorChooserFactoryTest.startAllExecutors(group);
            Thread.sleep(200L);
            Assertions.assertEquals((int)1, (int)group.activeExecutorCount());
            TestEventExecutor activeExecutor = null;
            Iterator iterator = group.iterator();
            while (iterator.hasNext()) {
                EventExecutor exec = (EventExecutor)iterator.next();
                if (exec.isSuspended()) continue;
                activeExecutor = (TestEventExecutor)exec;
                break;
            }
            if (activeExecutor == null) {
                Assertions.fail((String)"Could not find an active executor to stress.");
            }
            activeExecutor.setHighLoad(true);
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(5L);
            while (group.activeExecutorCount() < 2 && System.nanoTime() < deadline) {
                Thread.sleep(50L);
            }
            Assertions.assertEquals((int)2, (int)group.activeExecutorCount(), (String)"Should scale up to maxThreads");
            Iterator iterator2 = group.iterator();
            while (iterator2.hasNext()) {
                EventExecutor exec = (EventExecutor)iterator2.next();
                if (exec.isSuspended()) continue;
                ((TestEventExecutor)exec).setHighLoad(true);
            }
            group.next();
            Thread.sleep(200L);
            Assertions.assertEquals((int)2, (int)group.activeExecutorCount(), (String)"Should not scale back down while load is high");
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    void testSmarterPickingConsolidatesWorkOnActiveExecutor() throws InterruptedException {
        TestEventExecutorGroup group = new TestEventExecutorGroup(1, 3, 50L, TimeUnit.MILLISECONDS);
        try {
            AutoScalingEventExecutorChooserFactoryTest.startAllExecutors(group);
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(5L);
            while (group.activeExecutorCount() > 1 && System.nanoTime() < deadline) {
                Thread.sleep(50L);
            }
            Assertions.assertEquals((int)1, (int)group.activeExecutorCount(), (String)"Group should scale down to 1 active executor");
            for (int i = 0; i < 5; ++i) {
                group.next().execute(() -> {});
                Thread.sleep(20L);
            }
            Assertions.assertEquals((int)1, (int)group.activeExecutorCount(), (String)"Should consolidate the trickle of work onto the single active executor, without waking up the suspended ones");
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    void testMetricsProvideCorrectUtilizationAndActiveExecutorCount() throws InterruptedException {
        TestEventExecutorGroup group = new TestEventExecutorGroup(1, 3, 50L, TimeUnit.MILLISECONDS);
        try {
            List utilizationMetrics;
            AutoScalingEventExecutorChooserFactoryTest.startAllExecutors(group);
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(5L);
            while (group.activeExecutorCount() > 1 && System.nanoTime() < deadline) {
                Thread.sleep(50L);
            }
            Assertions.assertEquals((int)1, (int)group.activeExecutorCount(), (String)"Should have scaled down to 1 active executor.");
            TestEventExecutor activeExecutor = null;
            Iterator iterator = group.iterator();
            while (iterator.hasNext()) {
                EventExecutor exec = (EventExecutor)iterator.next();
                if (exec.isSuspended()) continue;
                activeExecutor = (TestEventExecutor)exec;
                break;
            }
            if (activeExecutor == null) {
                Assertions.fail((String)"Could not find an active executor.");
            }
            activeExecutor.setHighLoad(true);
            while (System.nanoTime() < deadline) {
                utilizationMetrics = group.executorUtilizations();
                TestEventExecutor finalActiveExecutor = activeExecutor;
                double utilization = utilizationMetrics.stream().filter(metric -> metric.executor().equals((Object)finalActiveExecutor)).findFirst().map(AutoScalingEventExecutorChooserFactory.AutoScalingUtilizationMetric::utilization).orElse(0.0);
                if (utilization > 0.4) break;
                Thread.sleep(50L);
            }
            Assertions.assertEquals((int)1, (int)group.activeExecutorCount(), (String)"Active count should still be 1 before scaling up.");
            utilizationMetrics = group.executorUtilizations();
            Assertions.assertEquals((int)3, (int)utilizationMetrics.size(), (String)"Utilization list should report on all executors.");
            TestEventExecutor finalActiveExecutor2 = activeExecutor;
            double activeUtilization = utilizationMetrics.stream().filter(metric -> metric.executor().equals((Object)finalActiveExecutor2)).findFirst().map(AutoScalingEventExecutorChooserFactory.AutoScalingUtilizationMetric::utilization).orElse(0.0);
            Assertions.assertTrue((activeUtilization > 0.4 ? 1 : 0) != 0, (String)("Active executor should have utilization above the scale-down threshold. Was: " + activeUtilization));
            TestEventExecutor finalActiveExecutor1 = activeExecutor;
            utilizationMetrics.stream().filter(metric -> metric.executor() != finalActiveExecutor1).forEach(metric -> {
                Assertions.assertTrue((boolean)metric.executor().isSuspended(), (String)"Other executors should be suspended.");
                Assertions.assertEquals((double)0.0, (double)metric.utilization(), (String)"Suspended executor should have 0.0 utilization.");
            });
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    private static void startAllExecutors(MultithreadEventExecutorGroup group) throws InterruptedException {
        CountDownLatch startLatch = new CountDownLatch(group.executorCount());
        for (EventExecutor executor : group) {
            executor.execute(startLatch::countDown);
        }
        startLatch.await();
    }

    private static final class TestEventExecutorGroup
    extends MultithreadEventExecutorGroup {
        private static final Object[] ARGS = new Object[0];

        TestEventExecutorGroup(int minThreads, int maxThreads, long checkPeriod, TimeUnit unit) {
            super(maxThreads, (Executor)new ThreadPerTaskExecutor(Executors.defaultThreadFactory()), (EventExecutorChooserFactory)new AutoScalingEventExecutorChooserFactory(minThreads, maxThreads, checkPeriod, unit, 0.4, 0.6, maxThreads, maxThreads, 2), ARGS);
        }

        protected EventExecutor newChild(Executor executor, Object ... args) {
            return new TestEventExecutor((EventExecutorGroup)this, executor);
        }
    }

    private static final class TestEventExecutor
    extends SingleThreadEventExecutor {
        private final AtomicBoolean highLoad = new AtomicBoolean(false);

        TestEventExecutor(EventExecutorGroup parent, Executor executor) {
            super(parent, executor, true, true, DEFAULT_MAX_PENDING_EXECUTOR_TASKS, RejectedExecutionHandlers.reject());
        }

        void setHighLoad(boolean highLoad) {
            this.highLoad.set(highLoad);
        }

        protected void run() {
            do {
                if (this.highLoad.get()) {
                    this.runAllTasks(TimeUnit.MILLISECONDS.toNanos(20L));
                    long busyWorkStart = this.ticker().nanoTime();
                    AutoScalingEventExecutorChooserFactoryTest.busyTask(35L, TimeUnit.MILLISECONDS);
                    long busyWorkEnd = this.ticker().nanoTime();
                    this.reportActiveIoTime(busyWorkEnd - busyWorkStart);
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                boolean ranTask = this.runAllTasks();
                if (ranTask) {
                    this.updateLastExecutionTime();
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            } while (!this.confirmShutdown() && !this.canSuspend());
        }
    }
}

