/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IntObjectHashMapTest {
    private IntObjectHashMap<Value> map;

    @BeforeEach
    public void setup() {
        this.map = new IntObjectHashMap();
    }

    @Test
    public void iteratorRemoveShouldNotNPE() {
        this.map = new IntObjectHashMap(4, 1.0f);
        this.map.put(Integer.valueOf(0), (Object)new Value("A"));
        this.map.put(Integer.valueOf(1), (Object)new Value("B"));
        this.map.put(Integer.valueOf(4), (Object)new Value("C"));
        this.map.remove((Object)1);
        Iterator itr = this.map.entries().iterator();
        while (itr.hasNext()) {
            IntObjectMap.PrimitiveEntry entry = (IntObjectMap.PrimitiveEntry)itr.next();
            Assertions.assertNotNull((Object)entry.key());
            Assertions.assertNotNull((Object)entry.value());
            itr.remove();
        }
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void putNewMappingShouldSucceed() {
        Value v = new Value("v");
        int key = 1;
        Assertions.assertNull((Object)this.map.put(key, (Object)v));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey(key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
        Assertions.assertEquals((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void putNewMappingShouldSucceed_mapApi() {
        Value v = new Value("v");
        Integer key = 1;
        Assertions.assertNull((Object)this.map.put(key, (Object)v));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
        Assertions.assertEquals((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldReplaceValue() {
        Value v1 = new Value("v1");
        int key = 1;
        Assertions.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assertions.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey(key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assertions.assertEquals((Object)v2, (Object)this.map.get(key));
    }

    @Test
    public void putShouldReplaceValue_mapApi() {
        Value v1 = new Value("v1");
        Integer key = 1;
        Assertions.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assertions.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assertions.assertEquals((Object)v2, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldGrowMap() {
        for (int key = 0; key < 255; ++key) {
            Value v = new Value(Integer.toString(key));
            Assertions.assertNull((Object)this.map.put(key, (Object)v));
            Assertions.assertEquals((int)(key + 1), (int)this.map.size());
            Assertions.assertTrue((boolean)this.map.containsKey(key));
            Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
            Assertions.assertEquals((Object)v, (Object)this.map.get(key));
        }
    }

    @Test
    public void putShouldGrowMap_mapApi() {
        for (int key = 0; key < 255; ++key) {
            Integer okey = key;
            Value v = new Value(Integer.toString(key));
            Assertions.assertNull((Object)this.map.put(okey, (Object)v));
            Assertions.assertEquals((int)(key + 1), (int)this.map.size());
            Assertions.assertTrue((boolean)this.map.containsKey((Object)okey));
            Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
            Assertions.assertEquals((Object)v, (Object)this.map.get((Object)okey));
        }
    }

    @Test
    public void negativeKeyShouldSucceed() {
        Value v = new Value("v");
        this.map.put(-3, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)v, (Object)this.map.get(-3));
    }

    @Test
    public void negativeKeyShouldSucceed_mapApi() {
        Value v = new Value("v");
        this.map.put(Integer.valueOf(-3), (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)v, (Object)this.map.get((Object)-3));
    }

    @Test
    public void removeMissingValueShouldReturnNull() {
        Assertions.assertNull((Object)this.map.remove(1));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void removeMissingValueShouldReturnNull_mapApi() {
        Assertions.assertNull((Object)this.map.remove((Object)1));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void removeShouldReturnPreviousValue() {
        Value v = new Value("v");
        int key = 1;
        this.map.put(key, (Object)v);
        Assertions.assertSame((Object)v, (Object)this.map.remove(key));
    }

    @Test
    public void removeShouldReturnPreviousValue_mapApi() {
        Value v = new Value("v");
        Integer key = 1;
        this.map.put(key, (Object)v);
        Assertions.assertSame((Object)v, (Object)this.map.remove((Object)key));
    }

    @Test
    public void noFreeSlotsShouldRehash() {
        for (int i = 0; i < 10; ++i) {
            this.map.put(i, (Object)new Value(Integer.toString(i)));
            this.map.remove(i);
            Assertions.assertEquals((int)0, (int)this.map.size());
        }
        Value v = new Value("v");
        int key = 1;
        this.map.put(key, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertSame((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void noFreeSlotsShouldRehash_mapApi() {
        for (int i = 0; i < 10; ++i) {
            this.map.put(i, (Object)new Value(Integer.toString(i)));
            this.map.remove((Object)i);
            Assertions.assertEquals((int)0, (int)this.map.size());
        }
        Value v = new Value("v");
        Integer key = 1;
        this.map.put(key, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertSame((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putAllShouldSucceed() {
        IntObjectHashMap other = new IntObjectHashMap();
        int k1 = 1;
        int k2 = 2;
        int k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get(k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get(k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get(k3));
    }

    @Test
    public void putAllShouldSucceed_mapApi() {
        IntObjectHashMap other = new IntObjectHashMap();
        Integer k1 = 1;
        Integer k2 = 2;
        Integer k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void putAllWithJavaMapShouldSucceed_mapApi() {
        HashMap<Integer, Value> other = new HashMap<Integer, Value>();
        Integer k1 = 1;
        Integer k2 = 2;
        Integer k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, v1);
        other.put(k2, v2);
        other.put(k3, v3);
        this.map.putAll(other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void clearShouldSucceed() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(1, (Object)v1);
        this.map.put(2, (Object)v2);
        this.map.put(3, (Object)v3);
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void containsValueShouldFindNull() {
        this.map.put(1, (Object)new Value("v1"));
        this.map.put(2, null);
        this.map.put(3, (Object)new Value("v2"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindNull_mapApi() {
        this.map.put(Integer.valueOf(1), (Object)new Value("v1"));
        this.map.put(Integer.valueOf(2), null);
        this.map.put(Integer.valueOf(3), (Object)new Value("v2"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindInstance() {
        Value v = new Value("v1");
        this.map.put(1, (Object)new Value("v2"));
        this.map.put(2, (Object)new Value("v3"));
        this.map.put(3, (Object)v);
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindInstance_mapApi() {
        Value v = new Value("v1");
        this.map.put(Integer.valueOf(1), (Object)new Value("v2"));
        this.map.put(Integer.valueOf(2), (Object)new Value("v3"));
        this.map.put(Integer.valueOf(3), (Object)v);
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindEquivalentValue() {
        this.map.put(1, (Object)new Value("v1"));
        this.map.put(2, (Object)new Value("v2"));
        this.map.put(3, (Object)new Value("v3"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueShouldFindEquivalentValue_mapApi() {
        this.map.put(Integer.valueOf(1), (Object)new Value("v1"));
        this.map.put(Integer.valueOf(2), (Object)new Value("v2"));
        this.map.put(Integer.valueOf(3), (Object)new Value("v3"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueNotFindMissingValue() {
        this.map.put(1, (Object)new Value("v1"));
        this.map.put(2, (Object)new Value("v2"));
        this.map.put(3, (Object)new Value("v3"));
        Assertions.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void containsValueNotFindMissingValue_mapApi() {
        this.map.put(Integer.valueOf(1), (Object)new Value("v1"));
        this.map.put(Integer.valueOf(2), (Object)new Value("v2"));
        this.map.put(Integer.valueOf(3), (Object)new Value("v3"));
        Assertions.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void iteratorShouldTraverseEntries() {
        int k1 = 1;
        int k2 = 2;
        int k3 = 3;
        int k4 = 4;
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet<Integer> found = new HashSet<Integer>();
        for (Map.Entry entry : this.map.entrySet()) {
            Assertions.assertTrue((boolean)found.add((Integer)entry.getKey()));
        }
        Assertions.assertEquals((int)3, (int)found.size());
        Assertions.assertTrue((boolean)found.contains(k1));
        Assertions.assertTrue((boolean)found.contains(k2));
        Assertions.assertTrue((boolean)found.contains(k3));
    }

    @Test
    public void keysShouldBeReturned() {
        int k1 = 1;
        int k2 = 2;
        int k3 = 3;
        int k4 = 4;
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        Set keys = this.map.keySet();
        Assertions.assertEquals((int)3, (int)keys.size());
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(k1);
        expected.add(k2);
        expected.add(k3);
        HashSet<Integer> found = new HashSet<Integer>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            Assertions.assertTrue((boolean)found.add(key));
        }
        Assertions.assertEquals(expected, found);
    }

    @Test
    public void valuesShouldBeReturned() {
        int k1 = 1;
        int k2 = 2;
        int k3 = 3;
        int k4 = 4;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(k1, (Object)v1);
        this.map.put(k2, (Object)v2);
        this.map.put(k3, (Object)v3);
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet<Value> expected = new HashSet<Value>();
        expected.add(v1);
        expected.add(v2);
        expected.add(v3);
        HashSet actual = new HashSet(this.map.values());
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void mapShouldSupportHashingConflicts() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                IntObjectHashMap map = new IntObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put(i * mod, (Object)"");
                }
            }
        }
    }

    @Test
    public void mapShouldSupportHashingConflicts_mapApi() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                IntObjectHashMap map = new IntObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put(Integer.valueOf(i * mod), (Object)"");
                }
            }
        }
    }

    @Test
    public void hashcodeEqualsTest() {
        IntObjectHashMap map1 = new IntObjectHashMap();
        IntObjectHashMap map2 = new IntObjectHashMap();
        Random rnd = new Random(0L);
        while (map1.size() < 100) {
            int key = rnd.nextInt(100);
            map1.put(key, (Object)key);
            map2.put(key, (Object)key);
        }
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
        Set keys = map1.keySet();
        Integer removed = null;
        Iterator iter = keys.iterator();
        for (int ix = 0; iter.hasNext() && ix < 50; ++ix) {
            removed = (Integer)iter.next();
        }
        map2.remove(removed);
        Assertions.assertFalse((boolean)map1.equals((Object)map2));
        map2.put(removed, (Object)removed);
        Assertions.assertEquals((Object)map1, (Object)map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put(100, (Object)100);
        Assertions.assertFalse((boolean)map1.equals((Object)map2));
        map2.clear();
        for (Integer key : map1.keySet()) {
            map2.put(key, (Object)key);
        }
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
    }

    @Test
    public void fuzzTest() {
        int key;
        int i;
        Random rnd = new Random(0L);
        int baseSize = 1000;
        int startTableSize = 1105;
        IntObjectHashMap map = new IntObjectHashMap(startTableSize);
        HashMap<Integer, Integer> goodMap = new HashMap<Integer, Integer>();
        for (i = 0; i < baseSize / 4; ++i) {
            key = rnd.nextInt(baseSize);
            Assertions.assertEquals((Integer)goodMap.put(key, key), (Integer)((Integer)map.put(key, (Object)key)));
            key = rnd.nextInt(baseSize) * 17;
            Assertions.assertEquals((Integer)goodMap.put(key, key), (Integer)((Integer)map.put(key, (Object)key)));
        }
        for (i = 0; i < baseSize * 1000; ++i) {
            key = rnd.nextInt(baseSize);
            if (rnd.nextDouble() >= 0.2) {
                Assertions.assertEquals((Integer)goodMap.put(key, key), (Integer)((Integer)map.put(key, (Object)key)));
                continue;
            }
            Assertions.assertEquals((Integer)((Integer)goodMap.remove(key)), (Integer)((Integer)map.remove(key)));
        }
        int removeSize = map.size() / 2;
        while (removeSize > 0) {
            key = rnd.nextInt(baseSize);
            boolean found = goodMap.containsKey(key);
            Assertions.assertEquals((Object)found, (Object)map.containsKey(key));
            Assertions.assertEquals((Integer)((Integer)goodMap.remove(key)), (Integer)((Integer)map.remove(key)));
            if (!found) continue;
            --removeSize;
        }
        Assertions.assertEquals((int)goodMap.size(), (int)map.size());
        Object[] goodKeys = goodMap.keySet().toArray(new Integer[goodMap.size()]);
        Arrays.sort(goodKeys);
        Object[] keys = map.keySet().toArray(new Integer[map.size()]);
        Arrays.sort(keys);
        for (int i2 = 0; i2 < goodKeys.length; ++i2) {
            Assertions.assertEquals((Integer)goodKeys[i2], (Integer)keys[i2]);
        }
        Object[] objectArray = keys;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            int key2 = (Integer)objectArray[j];
            Assertions.assertEquals((Integer)((Integer)goodMap.remove(key2)), (Integer)((Integer)map.remove(key2)));
        }
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void valuesIteratorRemove() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(1, (Object)v1);
        this.map.put(2, (Object)v2);
        this.map.put(3, (Object)v3);
        Iterator it = this.map.values().iterator();
        Assertions.assertSame((Object)v1, it.next());
        Assertions.assertSame((Object)v2, it.next());
        it.remove();
        Assertions.assertSame((Object)v3, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get(1));
        Assertions.assertNull((Object)this.map.get(2));
        Assertions.assertSame((Object)v3, (Object)this.map.get(3));
        it = this.map.values().iterator();
        Assertions.assertSame((Object)v1, it.next());
        Assertions.assertSame((Object)v3, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    private static class Value {
        private final String name;

        Value(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

