/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.ByteObjectHashMap;
import io.netty.util.collection.ByteObjectMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteObjectHashMapTest {
    private ByteObjectHashMap<Value> map;

    @BeforeEach
    public void setup() {
        this.map = new ByteObjectHashMap();
    }

    @Test
    public void iteratorRemoveShouldNotNPE() {
        this.map = new ByteObjectHashMap(4, 1.0f);
        this.map.put(Byte.valueOf((byte)0), (Object)new Value("A"));
        this.map.put(Byte.valueOf((byte)1), (Object)new Value("B"));
        this.map.put(Byte.valueOf((byte)4), (Object)new Value("C"));
        this.map.remove((Object)1);
        Iterator itr = this.map.entries().iterator();
        while (itr.hasNext()) {
            ByteObjectMap.PrimitiveEntry entry = (ByteObjectMap.PrimitiveEntry)itr.next();
            Assertions.assertNotNull((Object)entry.key());
            Assertions.assertNotNull((Object)entry.value());
            itr.remove();
        }
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void putNewMappingShouldSucceed() {
        Value v = new Value("v");
        byte key = 1;
        Assertions.assertNull((Object)this.map.put(key, (Object)v));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey(key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
        Assertions.assertEquals((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void putNewMappingShouldSucceed_mapApi() {
        Value v = new Value("v");
        Byte key = 1;
        Assertions.assertNull((Object)this.map.put(key, (Object)v));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
        Assertions.assertEquals((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldReplaceValue() {
        Value v1 = new Value("v1");
        byte key = 1;
        Assertions.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assertions.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey(key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assertions.assertEquals((Object)v2, (Object)this.map.get(key));
    }

    @Test
    public void putShouldReplaceValue_mapApi() {
        Value v1 = new Value("v1");
        Byte key = 1;
        Assertions.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assertions.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assertions.assertEquals((Object)v2, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldGrowMap() {
        for (byte key = 0; key < -1; key = (byte)(key + 1)) {
            Value v = new Value(Byte.toString(key));
            Assertions.assertNull((Object)this.map.put(key, (Object)v));
            Assertions.assertEquals((int)(key + 1), (int)this.map.size());
            Assertions.assertTrue((boolean)this.map.containsKey(key));
            Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
            Assertions.assertEquals((Object)v, (Object)this.map.get(key));
        }
    }

    @Test
    public void putShouldGrowMap_mapApi() {
        for (byte key = 0; key < -1; key = (byte)(key + 1)) {
            Byte okey = key;
            Value v = new Value(Byte.toString(key));
            Assertions.assertNull((Object)this.map.put(okey, (Object)v));
            Assertions.assertEquals((int)(key + 1), (int)this.map.size());
            Assertions.assertTrue((boolean)this.map.containsKey((Object)okey));
            Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
            Assertions.assertEquals((Object)v, (Object)this.map.get((Object)okey));
        }
    }

    @Test
    public void negativeKeyShouldSucceed() {
        Value v = new Value("v");
        this.map.put((byte)-3, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)v, (Object)this.map.get((byte)-3));
    }

    @Test
    public void negativeKeyShouldSucceed_mapApi() {
        Value v = new Value("v");
        this.map.put(Byte.valueOf((byte)-3), (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)v, (Object)this.map.get((Object)-3));
    }

    @Test
    public void removeMissingValueShouldReturnNull() {
        Assertions.assertNull((Object)this.map.remove((byte)1));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void removeMissingValueShouldReturnNull_mapApi() {
        Assertions.assertNull((Object)this.map.remove((Object)1));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void removeShouldReturnPreviousValue() {
        Value v = new Value("v");
        byte key = 1;
        this.map.put(key, (Object)v);
        Assertions.assertSame((Object)v, (Object)this.map.remove(key));
    }

    @Test
    public void removeShouldReturnPreviousValue_mapApi() {
        Value v = new Value("v");
        Byte key = 1;
        this.map.put(key, (Object)v);
        Assertions.assertSame((Object)v, (Object)this.map.remove((Object)key));
    }

    @Test
    public void noFreeSlotsShouldRehash() {
        for (byte i = 0; i < 10; i = (byte)(i + 1)) {
            this.map.put(i, (Object)new Value(Byte.toString(i)));
            this.map.remove(i);
            Assertions.assertEquals((int)0, (int)this.map.size());
        }
        Value v = new Value("v");
        byte key = 1;
        this.map.put(key, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertSame((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void noFreeSlotsShouldRehash_mapApi() {
        for (byte i = 0; i < 10; i = (byte)(i + 1)) {
            this.map.put(i, (Object)new Value(Byte.toString(i)));
            this.map.remove((Object)i);
            Assertions.assertEquals((int)0, (int)this.map.size());
        }
        Value v = new Value("v");
        Byte key = 1;
        this.map.put(key, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertSame((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putAllShouldSucceed() {
        ByteObjectHashMap other = new ByteObjectHashMap();
        byte k1 = 1;
        byte k2 = 2;
        byte k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get(k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get(k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get(k3));
    }

    @Test
    public void putAllShouldSucceed_mapApi() {
        ByteObjectHashMap other = new ByteObjectHashMap();
        Byte k1 = 1;
        Byte k2 = 2;
        Byte k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void putAllWithJavaMapShouldSucceed_mapApi() {
        HashMap<Byte, Value> other = new HashMap<Byte, Value>();
        Byte k1 = 1;
        Byte k2 = 2;
        Byte k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, v1);
        other.put(k2, v2);
        other.put(k3, v3);
        this.map.putAll(other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void clearShouldSucceed() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put((byte)1, (Object)v1);
        this.map.put((byte)2, (Object)v2);
        this.map.put((byte)3, (Object)v3);
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void containsValueShouldFindNull() {
        this.map.put((byte)1, (Object)new Value("v1"));
        this.map.put((byte)2, null);
        this.map.put((byte)3, (Object)new Value("v2"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindNull_mapApi() {
        this.map.put(Byte.valueOf((byte)1), (Object)new Value("v1"));
        this.map.put(Byte.valueOf((byte)2), null);
        this.map.put(Byte.valueOf((byte)3), (Object)new Value("v2"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindInstance() {
        Value v = new Value("v1");
        this.map.put((byte)1, (Object)new Value("v2"));
        this.map.put((byte)2, (Object)new Value("v3"));
        this.map.put((byte)3, (Object)v);
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindInstance_mapApi() {
        Value v = new Value("v1");
        this.map.put(Byte.valueOf((byte)1), (Object)new Value("v2"));
        this.map.put(Byte.valueOf((byte)2), (Object)new Value("v3"));
        this.map.put(Byte.valueOf((byte)3), (Object)v);
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindEquivalentValue() {
        this.map.put((byte)1, (Object)new Value("v1"));
        this.map.put((byte)2, (Object)new Value("v2"));
        this.map.put((byte)3, (Object)new Value("v3"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueShouldFindEquivalentValue_mapApi() {
        this.map.put(Byte.valueOf((byte)1), (Object)new Value("v1"));
        this.map.put(Byte.valueOf((byte)2), (Object)new Value("v2"));
        this.map.put(Byte.valueOf((byte)3), (Object)new Value("v3"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueNotFindMissingValue() {
        this.map.put((byte)1, (Object)new Value("v1"));
        this.map.put((byte)2, (Object)new Value("v2"));
        this.map.put((byte)3, (Object)new Value("v3"));
        Assertions.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void containsValueNotFindMissingValue_mapApi() {
        this.map.put(Byte.valueOf((byte)1), (Object)new Value("v1"));
        this.map.put(Byte.valueOf((byte)2), (Object)new Value("v2"));
        this.map.put(Byte.valueOf((byte)3), (Object)new Value("v3"));
        Assertions.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void iteratorShouldTraverseEntries() {
        byte k1 = 1;
        byte k2 = 2;
        byte k3 = 3;
        byte k4 = 4;
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet<Byte> found = new HashSet<Byte>();
        for (Map.Entry entry : this.map.entrySet()) {
            Assertions.assertTrue((boolean)found.add((Byte)entry.getKey()));
        }
        Assertions.assertEquals((int)3, (int)found.size());
        Assertions.assertTrue((boolean)found.contains(k1));
        Assertions.assertTrue((boolean)found.contains(k2));
        Assertions.assertTrue((boolean)found.contains(k3));
    }

    @Test
    public void keysShouldBeReturned() {
        byte k1 = 1;
        byte k2 = 2;
        byte k3 = 3;
        byte k4 = 4;
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        Set keys = this.map.keySet();
        Assertions.assertEquals((int)3, (int)keys.size());
        HashSet<Byte> expected = new HashSet<Byte>();
        expected.add(k1);
        expected.add(k2);
        expected.add(k3);
        HashSet<Byte> found = new HashSet<Byte>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            byte key = (Byte)iterator.next();
            Assertions.assertTrue((boolean)found.add(key));
        }
        Assertions.assertEquals(expected, found);
    }

    @Test
    public void valuesShouldBeReturned() {
        byte k1 = 1;
        byte k2 = 2;
        byte k3 = 3;
        byte k4 = 4;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(k1, (Object)v1);
        this.map.put(k2, (Object)v2);
        this.map.put(k3, (Object)v3);
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet<Value> expected = new HashSet<Value>();
        expected.add(v1);
        expected.add(v2);
        expected.add(v3);
        HashSet actual = new HashSet(this.map.values());
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void mapShouldSupportHashingConflicts() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                ByteObjectHashMap map = new ByteObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put((byte)(i * mod), (Object)"");
                }
            }
        }
    }

    @Test
    public void mapShouldSupportHashingConflicts_mapApi() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                ByteObjectHashMap map = new ByteObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put(Byte.valueOf((byte)(i * mod)), (Object)"");
                }
            }
        }
    }

    @Test
    public void hashcodeEqualsTest() {
        ByteObjectHashMap map1 = new ByteObjectHashMap();
        ByteObjectHashMap map2 = new ByteObjectHashMap();
        Random rnd = new Random(0L);
        while (map1.size() < 100) {
            byte key = (byte)rnd.nextInt(100);
            map1.put(key, (Object)key);
            map2.put(key, (Object)key);
        }
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
        Set keys = map1.keySet();
        Byte removed = null;
        Iterator iter = keys.iterator();
        for (int ix = 0; iter.hasNext() && ix < 50; ++ix) {
            removed = (Byte)iter.next();
        }
        map2.remove(removed);
        Assertions.assertFalse((boolean)map1.equals((Object)map2));
        map2.put(removed, (Object)removed);
        Assertions.assertEquals((Object)map1, (Object)map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put((byte)100, (Object)100);
        Assertions.assertFalse((boolean)map1.equals((Object)map2));
        map2.clear();
        for (Byte key : map1.keySet()) {
            map2.put(key, (Object)key);
        }
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
    }

    @Test
    public void fuzzTest() {
        byte key;
        int i;
        Random rnd = new Random(0L);
        int baseSize = 1000;
        int startTableSize = 1105;
        ByteObjectHashMap map = new ByteObjectHashMap(startTableSize);
        HashMap<Byte, Byte> goodMap = new HashMap<Byte, Byte>();
        for (i = 0; i < baseSize / 4; ++i) {
            key = (byte)rnd.nextInt(baseSize);
            Assertions.assertEquals((Byte)goodMap.put(key, key), (Byte)((Byte)map.put(key, (Object)key)));
            key = (byte)(rnd.nextInt(baseSize) * 17);
            Assertions.assertEquals((Byte)goodMap.put(key, key), (Byte)((Byte)map.put(key, (Object)key)));
        }
        for (i = 0; i < baseSize * 1000; ++i) {
            key = (byte)rnd.nextInt(baseSize);
            if (rnd.nextDouble() >= 0.2) {
                Assertions.assertEquals((Byte)goodMap.put(key, key), (Byte)((Byte)map.put(key, (Object)key)));
                continue;
            }
            Assertions.assertEquals((Byte)((Byte)goodMap.remove(key)), (Byte)((Byte)map.remove(key)));
        }
        int removeSize = map.size() / 2;
        while (removeSize > 0) {
            key = (byte)rnd.nextInt(baseSize);
            boolean found = goodMap.containsKey(key);
            Assertions.assertEquals((Object)found, (Object)map.containsKey(key));
            Assertions.assertEquals((Byte)((Byte)goodMap.remove(key)), (Byte)((Byte)map.remove(key)));
            if (!found) continue;
            --removeSize;
        }
        Assertions.assertEquals((int)goodMap.size(), (int)map.size());
        Object[] goodKeys = goodMap.keySet().toArray(new Byte[goodMap.size()]);
        Arrays.sort(goodKeys);
        Object[] keys = map.keySet().toArray(new Byte[map.size()]);
        Arrays.sort(keys);
        for (int i2 = 0; i2 < goodKeys.length; ++i2) {
            Assertions.assertEquals((Byte)goodKeys[i2], (Byte)keys[i2]);
        }
        Object[] objectArray = keys;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            byte key2 = (Byte)objectArray[j];
            Assertions.assertEquals((Byte)((Byte)goodMap.remove(key2)), (Byte)((Byte)map.remove(key2)));
        }
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void valuesIteratorRemove() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put((byte)1, (Object)v1);
        this.map.put((byte)2, (Object)v2);
        this.map.put((byte)3, (Object)v3);
        Iterator it = this.map.values().iterator();
        Assertions.assertSame((Object)v1, it.next());
        Assertions.assertSame((Object)v2, it.next());
        it.remove();
        Assertions.assertSame((Object)v3, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((byte)1));
        Assertions.assertNull((Object)this.map.get((byte)2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((byte)3));
        it = this.map.values().iterator();
        Assertions.assertSame((Object)v1, it.next());
        Assertions.assertSame((Object)v3, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    private static class Value {
        private final String name;

        Value(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

