/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DatagramDnsQueryDecoder;
import io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DnsQueryTest {
    @Test
    public void testEncodeAndDecodeQuery() {
        InetSocketAddress addr = SocketUtils.socketAddress((String)"8.8.8.8", (int)53);
        EmbeddedChannel writeChannel = new EmbeddedChannel(new ChannelHandler[]{new DatagramDnsQueryEncoder()});
        EmbeddedChannel readChannel = new EmbeddedChannel(new ChannelHandler[]{new DatagramDnsQueryDecoder()});
        ArrayList<DatagramDnsQuery> queries = new ArrayList<DatagramDnsQuery>(5);
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("1.0.0.127.in-addr.arpa", DnsRecordType.PTR)));
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("www.example.com", DnsRecordType.A)));
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("example.com", DnsRecordType.AAAA)));
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("example.com", DnsRecordType.MX)));
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("example.com", DnsRecordType.CNAME)));
        for (DnsQuery dnsQuery : queries) {
            MatcherAssert.assertThat((Object)dnsQuery.count(DnsSection.QUESTION), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)dnsQuery.count(DnsSection.ANSWER), (Matcher)Matchers.is((Object)0));
            MatcherAssert.assertThat((Object)dnsQuery.count(DnsSection.AUTHORITY), (Matcher)Matchers.is((Object)0));
            MatcherAssert.assertThat((Object)dnsQuery.count(DnsSection.ADDITIONAL), (Matcher)Matchers.is((Object)0));
            Assertions.assertTrue((boolean)writeChannel.writeOutbound(new Object[]{dnsQuery}));
            DatagramPacket packet = (DatagramPacket)writeChannel.readOutbound();
            Assertions.assertTrue((boolean)((ByteBuf)packet.content()).isReadable());
            Assertions.assertTrue((boolean)readChannel.writeInbound(new Object[]{packet}));
            DnsQuery decodedDnsQuery = (DnsQuery)readChannel.readInbound();
            Assertions.assertEquals((Object)dnsQuery, (Object)decodedDnsQuery);
            Assertions.assertTrue((boolean)decodedDnsQuery.release());
            Assertions.assertNull((Object)writeChannel.readOutbound());
            Assertions.assertNull((Object)readChannel.readInbound());
        }
        Assertions.assertFalse((boolean)writeChannel.finish());
        Assertions.assertFalse((boolean)readChannel.finish());
    }
}

