/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.resourcemodels.registration;

import io.neba.api.spi.ResourceModelFactory;
import io.neba.spring.resourcemodels.registration.SpringBasedModelDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

class SpringResourceModelFactory
implements ResourceModelFactory {
    private final List<SpringBasedModelDefinition> modelDefinitions;
    private final ConfigurableListableBeanFactory factory;

    SpringResourceModelFactory(List<SpringBasedModelDefinition> modelDefinitions, ConfigurableListableBeanFactory factory) {
        this.modelDefinitions = modelDefinitions;
        this.factory = factory;
    }

    @Nonnull
    public Collection<ResourceModelFactory.ModelDefinition<?>> getModelDefinitions() {
        return new ArrayList(this.modelDefinitions);
    }

    public <T> T provideModel(@Nonnull ResourceModelFactory.ModelDefinition<T> modelDefinition, @Nonnull ResourceModelFactory.ContentToModelMappingCallback<T> callback) {
        if (!(modelDefinition instanceof SpringBasedModelDefinition)) {
            throw new IllegalArgumentException("Unable to provide the model " + modelDefinition + ": The model definition does not stem from spring. This factory should not have been asked to provide a model for it.");
        }
        SpringBasedModelDefinition springBasedModelDefinition = (SpringBasedModelDefinition)modelDefinition;
        Object bean = this.factory.getBean(springBasedModelDefinition.getBeanName(), modelDefinition.getType());
        return (T)callback.map(bean);
    }
}

