/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.resourcemodels.registration;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Annotations {
    private final AnnotatedElement annotatedElement;
    private Map<Class<? extends Annotation>, Annotation> annotations = null;

    static Annotations annotations(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            throw new IllegalArgumentException("Method argument annotatedElement must not be null.");
        }
        return new Annotations(annotatedElement);
    }

    private Annotations(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            throw new IllegalArgumentException("Constructor parameter annotatedElement must not be null.");
        }
        this.annotatedElement = annotatedElement;
    }

    public <T extends Annotation> T get(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Method argument type must not be null.");
        }
        return (T)this.getAnnotationMap().get(type);
    }

    private Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        if (this.annotations == null) {
            HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            LinkedList<Annotation> queue = new LinkedList<Annotation>(Arrays.asList(this.annotatedElement.getAnnotations()));
            while (!queue.isEmpty()) {
                Annotation annotation = (Annotation)queue.remove();
                if (annotations.containsKey(annotation.annotationType())) continue;
                annotations.put(annotation.annotationType(), annotation);
                Collections.addAll(queue, annotation.annotationType().getAnnotations());
            }
            this.annotations = annotations;
        }
        return this.annotations;
    }
}

